-- MariaDB dump 10.19  Distrib 10.4.32-MariaDB, for Win64 (AMD64)
--
-- Host: localhost    Database: smartonegroup_erp
-- ------------------------------------------------------
-- Server version	10.4.32-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `type` enum('asset','liability','equity','revenue','expense') NOT NULL,
  `parent_id` bigint(20) unsigned DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `current_balance` decimal(15,2) NOT NULL DEFAULT 0.00,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `accounts_code_unique` (`code`),
  KEY `accounts_parent_id_foreign` (`parent_id`),
  CONSTRAINT `accounts_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `accounts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,'1000','Assets','asset',NULL,1,0.00,'2026-02-01 20:55:37','2026-02-01 20:55:37'),(2,'1100','Current Assets','asset',1,1,0.00,'2026-02-01 20:55:37','2026-02-01 20:55:37'),(3,'1101','Cash on Hand','asset',2,1,0.00,'2026-02-01 20:55:37','2026-02-01 20:55:37'),(4,'1102','Bank Accounts','asset',2,1,0.00,'2026-02-01 20:55:37','2026-02-01 20:55:37'),(5,'1103','Accounts Receivable (Customers)','asset',2,1,0.00,'2026-02-01 20:55:37','2026-02-01 20:55:37'),(6,'1104','Inventory','asset',2,1,0.00,'2026-02-01 20:55:37','2026-02-01 20:55:37'),(7,'1200','Fixed Assets','asset',1,1,0.00,'2026-02-01 20:55:37','2026-02-01 20:55:37'),(8,'1201','Computers & Equipment','asset',7,1,0.00,'2026-02-01 20:55:37','2026-02-01 20:55:37'),(9,'1202','Furniture','asset',7,1,0.00,'2026-02-01 20:55:37','2026-02-01 20:55:37'),(10,'2000','Liabilities','liability',NULL,1,0.00,'2026-02-01 20:55:37','2026-02-01 20:55:37'),(11,'2100','Current Liabilities','liability',10,1,0.00,'2026-02-01 20:55:37','2026-02-01 20:55:37'),(12,'2101','Accounts Payable (Suppliers)','liability',11,1,0.00,'2026-02-01 20:55:37','2026-02-01 20:55:37'),(13,'2102','VAT Payable','liability',11,1,0.00,'2026-02-01 20:55:37','2026-02-01 20:55:37'),(14,'3000','Equity','equity',NULL,1,0.00,'2026-02-01 20:55:37','2026-02-01 20:55:37'),(15,'3100','Capital','equity',14,1,0.00,'2026-02-01 20:55:37','2026-02-01 20:55:37'),(16,'3200','Retained Earnings','equity',14,1,0.00,'2026-02-01 20:55:37','2026-02-01 20:55:37'),(17,'4000','Revenue','revenue',NULL,1,0.00,'2026-02-01 20:55:37','2026-02-01 20:55:37'),(18,'4100','Sales Services','revenue',17,1,0.00,'2026-02-01 20:55:37','2026-02-01 20:55:37'),(19,'4200','Hosting Revenue','revenue',17,1,0.00,'2026-02-01 20:55:37','2026-02-01 20:55:37'),(20,'5000','Expenses','expense',NULL,1,0.00,'2026-02-01 20:55:37','2026-02-01 20:55:37'),(21,'5100','Cost of Goods Sold','expense',20,1,0.00,'2026-02-01 20:55:37','2026-02-01 20:55:37'),(22,'5200','Salaries & Wages','expense',20,1,0.00,'2026-02-01 20:55:37','2026-02-01 20:55:37'),(23,'5300','Rent Expense','expense',20,1,0.00,'2026-02-01 20:55:37','2026-02-01 20:55:37'),(24,'5400','Utilities (Internet/Electricity)','expense',20,1,0.00,'2026-02-01 20:55:37','2026-02-01 20:55:37'),(25,'5500','Maintenance','expense',20,1,0.00,'2026-02-01 20:55:37','2026-02-01 20:55:37');
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendance_logs`
--

DROP TABLE IF EXISTS `attendance_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `attendance_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `date` date NOT NULL,
  `check_in` time DEFAULT NULL,
  `check_out` time DEFAULT NULL,
  `status` enum('present','late','absent','on_leave','half_day') NOT NULL DEFAULT 'present',
  `notes` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `attendance_logs_employee_id_date_unique` (`employee_id`,`date`),
  CONSTRAINT `attendance_logs_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendance_logs`
--

LOCK TABLES `attendance_logs` WRITE;
/*!40000 ALTER TABLE `attendance_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendance_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bills`
--

DROP TABLE IF EXISTS `bills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bills` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `supplier_id` bigint(20) unsigned NOT NULL,
  `currency_id` bigint(20) unsigned DEFAULT NULL,
  `exchange_rate` decimal(15,6) NOT NULL DEFAULT 1.000000,
  `code` varchar(255) NOT NULL,
  `date` date NOT NULL,
  `due_date` date DEFAULT NULL,
  `subtotal` decimal(15,2) NOT NULL DEFAULT 0.00,
  `tax_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `total` decimal(15,2) NOT NULL DEFAULT 0.00,
  `paid_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `status` enum('draft','sent','partial','paid','overdue','cancelled') NOT NULL DEFAULT 'draft',
  `notes` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `bills_code_unique` (`code`),
  KEY `bills_supplier_id_foreign` (`supplier_id`),
  KEY `bills_currency_id_foreign` (`currency_id`),
  CONSTRAINT `bills_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `bills_supplier_id_foreign` FOREIGN KEY (`supplier_id`) REFERENCES `suppliers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bills`
--

LOCK TABLES `bills` WRITE;
/*!40000 ALTER TABLE `bills` DISABLE KEYS */;
/*!40000 ALTER TABLE `bills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache` (
  `key` varchar(255) NOT NULL,
  `value` mediumtext NOT NULL,
  `expiration` int(11) NOT NULL,
  PRIMARY KEY (`key`),
  KEY `cache_expiration_index` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache`
--

LOCK TABLES `cache` WRITE;
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
INSERT INTO `cache` VALUES ('smartonegroup-erp-cache-setting_general_company_address','s:53:\"Abdelsalam Elshazly st , Damanhour , Elbehira , Egypt\";',2085758043),('smartonegroup-erp-cache-setting_general_company_name','s:17:\"SmartOneGroup ERP\";',2085758043),('smartonegroup-erp-cache-setting_general_company_phone','s:11:\"01112280212\";',2085758043),('smartonegroup-erp-cache-setting_general_company_tax_id','s:11:\"123-456-789\";',2085750483),('smartonegroup-erp-cache-setting_general_default_language','s:2:\"ar\";',2085758036),('smartonegroup-erp-cache-setting_modules_module_accounting','s:1:\"1\";',2085608243),('smartonegroup-erp-cache-setting_modules_module_ai','s:1:\"1\";',2085608243),('smartonegroup-erp-cache-setting_modules_module_crm','s:1:\"1\";',2085608243),('smartonegroup-erp-cache-setting_modules_module_hr','s:1:\"1\";',2085608243),('smartonegroup-erp-cache-setting_modules_module_inventory','s:1:\"1\";',2085608243),('smartonegroup-erp-cache-setting_modules_module_projects','s:1:\"1\";',2085608243),('smartonegroup-erp-cache-setting_modules_module_quotations','s:1:\"1\";',2085608243),('smartonegroup-erp-cache-setting_modules_module_subscriptions','s:1:\"1\";',2085608243),('smartonegroup-erp-cache-setting_smtp_encryption','s:3:\"ssl\";',2085656205),('smartonegroup-erp-cache-setting_smtp_from_address','s:11:\"info@sog.eg\";',2085656205),('smartonegroup-erp-cache-setting_smtp_from_name','s:17:\"SmartOneGroup ERP\";',2085656205),('smartonegroup-erp-cache-setting_smtp_host','s:14:\"smtp.gmail.com\";',2085612526),('smartonegroup-erp-cache-setting_smtp_password','s:9:\"Malek@007\";',2085656205),('smartonegroup-erp-cache-setting_smtp_port','s:3:\"587\";',2085656205),('smartonegroup-erp-cache-setting_smtp_username','s:11:\"info@sog.eg\";',2085656205),('smartonegroup-erp-cache-setting_wasender_api_key','s:0:\"\";',2085608381),('smartonegroup-erp-cache-setting_wasender_api_url','s:27:\"https://api.wasenderapi.com\";',2085608381),('smartonegroup-erp-cache-setting_wasender_session_id','s:0:\"\";',2085608381),('smartonegroup-erp-cache-setting_whmcs_api_identifier','s:32:\"ZwXxMNPu1CY1SbtDqCb6e5mnuHlrZLQT\";',2085612830),('smartonegroup-erp-cache-setting_whmcs_api_secret','s:32:\"OadS5Ps12JFPfWArjSvZ2xv8DliYmR0A\";',2085612830),('smartonegroup-erp-cache-setting_whmcs_api_url','s:23:\"https://service.sog.eg/\";',2085612526),('smartonegroup-erp-cache-spatie.permission.cache','a:3:{s:5:\"alias\";a:4:{s:1:\"a\";s:2:\"id\";s:1:\"b\";s:4:\"name\";s:1:\"c\";s:10:\"guard_name\";s:1:\"r\";s:5:\"roles\";}s:11:\"permissions\";a:126:{i:0;a:4:{s:1:\"a\";i:1;s:1:\"b\";s:16:\"manage customers\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:1;a:4:{s:1:\"a\";i:2;s:1:\"b\";s:15:\"manage settings\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:2;a:4:{s:1:\"a\";i:3;s:1:\"b\";s:14:\"view dashboard\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:3;a:4:{s:1:\"a\";i:4;s:1:\"b\";s:14:\"view customers\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:4;a:4:{s:1:\"a\";i:5;s:1:\"b\";s:16:\"create customers\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:5;a:4:{s:1:\"a\";i:6;s:1:\"b\";s:14:\"edit customers\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:6;a:4:{s:1:\"a\";i:7;s:1:\"b\";s:16:\"delete customers\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:7;a:4:{s:1:\"a\";i:8;s:1:\"b\";s:14:\"full customers\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:8;a:4:{s:1:\"a\";i:9;s:1:\"b\";s:14:\"view companies\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:9;a:4:{s:1:\"a\";i:10;s:1:\"b\";s:16:\"create companies\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:10;a:4:{s:1:\"a\";i:11;s:1:\"b\";s:14:\"edit companies\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:11;a:4:{s:1:\"a\";i:12;s:1:\"b\";s:16:\"delete companies\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:12;a:4:{s:1:\"a\";i:13;s:1:\"b\";s:14:\"full companies\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:13;a:4:{s:1:\"a\";i:14;s:1:\"b\";s:17:\"view transactions\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:14;a:4:{s:1:\"a\";i:15;s:1:\"b\";s:19:\"create transactions\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:15;a:4:{s:1:\"a\";i:16;s:1:\"b\";s:17:\"edit transactions\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:16;a:4:{s:1:\"a\";i:17;s:1:\"b\";s:19:\"delete transactions\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:17;a:4:{s:1:\"a\";i:18;s:1:\"b\";s:17:\"full transactions\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:18;a:4:{s:1:\"a\";i:19;s:1:\"b\";s:10:\"view sales\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:19;a:4:{s:1:\"a\";i:20;s:1:\"b\";s:12:\"create sales\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:20;a:4:{s:1:\"a\";i:21;s:1:\"b\";s:10:\"edit sales\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:21;a:4:{s:1:\"a\";i:22;s:1:\"b\";s:12:\"delete sales\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:22;a:4:{s:1:\"a\";i:23;s:1:\"b\";s:10:\"full sales\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:23;a:4:{s:1:\"a\";i:24;s:1:\"b\";s:15:\"view treasuries\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:24;a:4:{s:1:\"a\";i:25;s:1:\"b\";s:17:\"create treasuries\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:25;a:4:{s:1:\"a\";i:26;s:1:\"b\";s:15:\"edit treasuries\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:26;a:4:{s:1:\"a\";i:27;s:1:\"b\";s:17:\"delete treasuries\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:27;a:4:{s:1:\"a\";i:28;s:1:\"b\";s:15:\"full treasuries\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:28;a:4:{s:1:\"a\";i:29;s:1:\"b\";s:13:\"view products\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:29;a:4:{s:1:\"a\";i:30;s:1:\"b\";s:15:\"create products\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:30;a:4:{s:1:\"a\";i:31;s:1:\"b\";s:13:\"edit products\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:31;a:4:{s:1:\"a\";i:32;s:1:\"b\";s:15:\"delete products\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:32;a:4:{s:1:\"a\";i:33;s:1:\"b\";s:13:\"full products\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:33;a:4:{s:1:\"a\";i:34;s:1:\"b\";s:12:\"view reports\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:34;a:4:{s:1:\"a\";i:35;s:1:\"b\";s:14:\"create reports\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:35;a:4:{s:1:\"a\";i:36;s:1:\"b\";s:12:\"edit reports\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:36;a:4:{s:1:\"a\";i:37;s:1:\"b\";s:14:\"delete reports\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:37;a:4:{s:1:\"a\";i:38;s:1:\"b\";s:12:\"full reports\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:38;a:4:{s:1:\"a\";i:39;s:1:\"b\";s:14:\"view utilities\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:39;a:4:{s:1:\"a\";i:40;s:1:\"b\";s:16:\"create utilities\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:40;a:4:{s:1:\"a\";i:41;s:1:\"b\";s:14:\"edit utilities\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:41;a:4:{s:1:\"a\";i:42;s:1:\"b\";s:16:\"delete utilities\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:42;a:4:{s:1:\"a\";i:43;s:1:\"b\";s:14:\"full utilities\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:43;a:4:{s:1:\"a\";i:44;s:1:\"b\";s:15:\"view appearance\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:44;a:4:{s:1:\"a\";i:45;s:1:\"b\";s:17:\"create appearance\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:45;a:4:{s:1:\"a\";i:46;s:1:\"b\";s:15:\"edit appearance\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:46;a:4:{s:1:\"a\";i:47;s:1:\"b\";s:17:\"delete appearance\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:47;a:4:{s:1:\"a\";i:48;s:1:\"b\";s:15:\"full appearance\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:48;a:4:{s:1:\"a\";i:49;s:1:\"b\";s:12:\"view plugins\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:49;a:4:{s:1:\"a\";i:50;s:1:\"b\";s:14:\"create plugins\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:50;a:4:{s:1:\"a\";i:51;s:1:\"b\";s:12:\"edit plugins\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:51;a:4:{s:1:\"a\";i:52;s:1:\"b\";s:14:\"delete plugins\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:52;a:4:{s:1:\"a\";i:53;s:1:\"b\";s:12:\"full plugins\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:53;a:4:{s:1:\"a\";i:54;s:1:\"b\";s:13:\"view calendar\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:54;a:4:{s:1:\"a\";i:55;s:1:\"b\";s:15:\"create calendar\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:55;a:4:{s:1:\"a\";i:56;s:1:\"b\";s:13:\"edit calendar\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:56;a:4:{s:1:\"a\";i:57;s:1:\"b\";s:15:\"delete calendar\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:57;a:4:{s:1:\"a\";i:58;s:1:\"b\";s:13:\"full calendar\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:58;a:4:{s:1:\"a\";i:59;s:1:\"b\";s:10:\"view leads\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:59;a:4:{s:1:\"a\";i:60;s:1:\"b\";s:12:\"create leads\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:60;a:4:{s:1:\"a\";i:61;s:1:\"b\";s:10:\"edit leads\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:61;a:4:{s:1:\"a\";i:62;s:1:\"b\";s:12:\"delete leads\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:62;a:4:{s:1:\"a\";i:63;s:1:\"b\";s:10:\"full leads\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:63;a:4:{s:1:\"a\";i:64;s:1:\"b\";s:10:\"view tasks\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:64;a:4:{s:1:\"a\";i:65;s:1:\"b\";s:12:\"create tasks\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:65;a:4:{s:1:\"a\";i:66;s:1:\"b\";s:10:\"edit tasks\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:66;a:4:{s:1:\"a\";i:67;s:1:\"b\";s:12:\"delete tasks\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:67;a:4:{s:1:\"a\";i:68;s:1:\"b\";s:10:\"full tasks\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:68;a:4:{s:1:\"a\";i:69;s:1:\"b\";s:14:\"view contracts\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:69;a:4:{s:1:\"a\";i:70;s:1:\"b\";s:16:\"create contracts\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:70;a:4:{s:1:\"a\";i:71;s:1:\"b\";s:14:\"edit contracts\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:71;a:4:{s:1:\"a\";i:72;s:1:\"b\";s:16:\"delete contracts\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:72;a:4:{s:1:\"a\";i:73;s:1:\"b\";s:14:\"full contracts\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:73;a:4:{s:1:\"a\";i:74;s:1:\"b\";s:11:\"view orders\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:74;a:4:{s:1:\"a\";i:75;s:1:\"b\";s:13:\"create orders\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:75;a:4:{s:1:\"a\";i:76;s:1:\"b\";s:11:\"edit orders\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:76;a:4:{s:1:\"a\";i:77;s:1:\"b\";s:13:\"delete orders\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:77;a:4:{s:1:\"a\";i:78;s:1:\"b\";s:11:\"full orders\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:78;a:4:{s:1:\"a\";i:79;s:1:\"b\";s:13:\"view settings\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:79;a:4:{s:1:\"a\";i:80;s:1:\"b\";s:15:\"create settings\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:80;a:4:{s:1:\"a\";i:81;s:1:\"b\";s:13:\"edit settings\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:81;a:4:{s:1:\"a\";i:82;s:1:\"b\";s:15:\"delete settings\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:82;a:4:{s:1:\"a\";i:83;s:1:\"b\";s:13:\"full settings\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:83;a:4:{s:1:\"a\";i:84;s:1:\"b\";s:14:\"view documents\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:84;a:4:{s:1:\"a\";i:85;s:1:\"b\";s:16:\"create documents\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:85;a:4:{s:1:\"a\";i:86;s:1:\"b\";s:14:\"edit documents\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:86;a:4:{s:1:\"a\";i:87;s:1:\"b\";s:16:\"delete documents\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:87;a:4:{s:1:\"a\";i:88;s:1:\"b\";s:14:\"full documents\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:88;a:4:{s:1:\"a\";i:89;s:1:\"b\";s:12:\"view loyalty\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:89;a:4:{s:1:\"a\";i:90;s:1:\"b\";s:14:\"create loyalty\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:90;a:4:{s:1:\"a\";i:91;s:1:\"b\";s:12:\"edit loyalty\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:91;a:4:{s:1:\"a\";i:92;s:1:\"b\";s:14:\"delete loyalty\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:92;a:4:{s:1:\"a\";i:93;s:1:\"b\";s:12:\"full loyalty\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:93;a:4:{s:1:\"a\";i:94;s:1:\"b\";s:10:\"view whmcs\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:94;a:4:{s:1:\"a\";i:95;s:1:\"b\";s:12:\"create whmcs\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:95;a:4:{s:1:\"a\";i:96;s:1:\"b\";s:10:\"edit whmcs\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:96;a:4:{s:1:\"a\";i:97;s:1:\"b\";s:12:\"delete whmcs\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:97;a:4:{s:1:\"a\";i:98;s:1:\"b\";s:10:\"full whmcs\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:98;a:4:{s:1:\"a\";i:99;s:1:\"b\";s:15:\"view sales_team\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:99;a:4:{s:1:\"a\";i:100;s:1:\"b\";s:17:\"create sales_team\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:100;a:4:{s:1:\"a\";i:101;s:1:\"b\";s:15:\"edit sales_team\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:101;a:4:{s:1:\"a\";i:102;s:1:\"b\";s:17:\"delete sales_team\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:102;a:4:{s:1:\"a\";i:103;s:1:\"b\";s:15:\"full sales_team\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:103;a:4:{s:1:\"a\";i:104;s:1:\"b\";s:13:\"view projects\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:104;a:4:{s:1:\"a\";i:105;s:1:\"b\";s:15:\"create projects\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:105;a:4:{s:1:\"a\";i:106;s:1:\"b\";s:13:\"edit projects\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:106;a:4:{s:1:\"a\";i:107;s:1:\"b\";s:15:\"delete projects\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:107;a:4:{s:1:\"a\";i:108;s:1:\"b\";s:13:\"full projects\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:108;a:4:{s:1:\"a\";i:109;s:1:\"b\";s:13:\"view invoices\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:109;a:4:{s:1:\"a\";i:110;s:1:\"b\";s:15:\"create invoices\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:110;a:4:{s:1:\"a\";i:111;s:1:\"b\";s:13:\"edit invoices\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:111;a:4:{s:1:\"a\";i:112;s:1:\"b\";s:15:\"delete invoices\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:112;a:4:{s:1:\"a\";i:113;s:1:\"b\";s:13:\"full invoices\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:113;a:4:{s:1:\"a\";i:114;s:1:\"b\";s:15:\"view attendance\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:114;a:4:{s:1:\"a\";i:115;s:1:\"b\";s:17:\"create attendance\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:115;a:4:{s:1:\"a\";i:116;s:1:\"b\";s:15:\"edit attendance\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:116;a:4:{s:1:\"a\";i:117;s:1:\"b\";s:17:\"delete attendance\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:117;a:4:{s:1:\"a\";i:118;s:1:\"b\";s:15:\"full attendance\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:118;a:4:{s:1:\"a\";i:119;s:1:\"b\";s:12:\"view payroll\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:119;a:4:{s:1:\"a\";i:120;s:1:\"b\";s:14:\"create payroll\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:120;a:4:{s:1:\"a\";i:121;s:1:\"b\";s:12:\"edit payroll\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:121;a:4:{s:1:\"a\";i:122;s:1:\"b\";s:14:\"delete payroll\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:122;a:4:{s:1:\"a\";i:123;s:1:\"b\";s:12:\"full payroll\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:123;a:4:{s:1:\"a\";i:124;s:1:\"b\";s:17:\"view own projects\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:2:{i:0;i:1;i:1;i:3;}}i:124;a:4:{s:1:\"a\";i:125;s:1:\"b\";s:27:\"update own project progress\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:2:{i:0;i:1;i:1;i:3;}}i:125;a:4:{s:1:\"a\";i:126;s:1:\"b\";s:17:\"view own payments\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:2:{i:0;i:1;i:1;i:3;}}}s:5:\"roles\";a:2:{i:0;a:3:{s:1:\"a\";i:1;s:1:\"b\";s:5:\"admin\";s:1:\"c\";s:3:\"web\";}i:1;a:3:{s:1:\"a\";i:3;s:1:\"b\";s:10:\"programmer\";s:1:\"c\";s:3:\"web\";}}}',1770422908);
/*!40000 ALTER TABLE `cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_locks`
--

DROP TABLE IF EXISTS `cache_locks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_locks` (
  `key` varchar(255) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expiration` int(11) NOT NULL,
  PRIMARY KEY (`key`),
  KEY `cache_locks_expiration_index` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_locks`
--

LOCK TABLES `cache_locks` WRITE;
/*!40000 ALTER TABLE `cache_locks` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_locks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `currencies`
--

DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currencies` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(10) NOT NULL,
  `name` varchar(255) NOT NULL,
  `symbol` varchar(10) NOT NULL,
  `exchange_rate` decimal(15,6) NOT NULL DEFAULT 1.000000,
  `is_base` tinyint(1) NOT NULL DEFAULT 0,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `points_per_currency_unit` decimal(10,2) NOT NULL DEFAULT 1.00 COMMENT 'Points earned per 1 unit of this currency',
  PRIMARY KEY (`id`),
  UNIQUE KEY `currencies_code_unique` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `currencies`
--

LOCK TABLES `currencies` WRITE;
/*!40000 ALTER TABLE `currencies` DISABLE KEYS */;
INSERT INTO `currencies` VALUES (1,'EGP','Egyptian Pound','ج.م',1.000000,1,1,'2026-02-01 22:21:09','2026-02-01 22:21:09',1.00),(2,'USD','US Dollar','$',47.000000,0,1,'2026-02-01 22:21:09','2026-02-06 14:47:20',1.00),(3,'ريال سعودى','ريال سعودى','ريال سعودى',12.500000,0,1,'2026-02-06 13:09:30','2026-02-06 13:09:30',1.00);
/*!40000 ALTER TABLE `currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customer_documents`
--

DROP TABLE IF EXISTS `customer_documents`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customer_documents` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint(20) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `file_path` varchar(500) NOT NULL,
  `file_type` varchar(50) DEFAULT NULL,
  `file_size` int(10) unsigned DEFAULT NULL,
  `uploaded_by` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_documents_customer_id_foreign` (`customer_id`),
  KEY `customer_documents_uploaded_by_foreign` (`uploaded_by`),
  CONSTRAINT `customer_documents_customer_id_foreign` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`id`) ON DELETE CASCADE,
  CONSTRAINT `customer_documents_uploaded_by_foreign` FOREIGN KEY (`uploaded_by`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customer_documents`
--

LOCK TABLES `customer_documents` WRITE;
/*!40000 ALTER TABLE `customer_documents` DISABLE KEYS */;
/*!40000 ALTER TABLE `customer_documents` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customer_groups`
--

DROP TABLE IF EXISTS `customer_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customer_groups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `discount_percentage` decimal(5,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `points_unit` int(11) NOT NULL DEFAULT 100,
  `currency_unit` decimal(10,2) NOT NULL DEFAULT 0.00,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customer_groups`
--

LOCK TABLES `customer_groups` WRITE;
/*!40000 ALTER TABLE `customer_groups` DISABLE KEYS */;
INSERT INTO `customer_groups` VALUES (1,'Silver',3.00,'عملاء silver هما العملاء الحاصلين على اكثر من 3 خدمات',100,1.00,'2026-02-03 17:40:33','2026-02-06 13:10:04'),(4,'Gold',5.00,'عملاء gold هما العملاء الحاصلين على اكثر من 5 خدمات',100,3.00,'2026-02-04 17:54:30','2026-02-06 13:10:18'),(5,'pro',10.00,'عملاء pro هما العملاء الحاصلين على اكثر من 10 خدمات',100,5.00,'2026-02-04 17:55:17','2026-02-06 13:10:28');
/*!40000 ALTER TABLE `customer_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customer_notes`
--

DROP TABLE IF EXISTS `customer_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customer_notes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `note` text NOT NULL,
  `is_private` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_notes_customer_id_foreign` (`customer_id`),
  KEY `customer_notes_user_id_foreign` (`user_id`),
  CONSTRAINT `customer_notes_customer_id_foreign` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`id`) ON DELETE CASCADE,
  CONSTRAINT `customer_notes_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customer_notes`
--

LOCK TABLES `customer_notes` WRITE;
/*!40000 ALTER TABLE `customer_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `customer_notes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customer_wallet_transactions`
--

DROP TABLE IF EXISTS `customer_wallet_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customer_wallet_transactions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint(20) unsigned NOT NULL,
  `type` enum('deposit','withdrawal','invoice_payment','adjustment') NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `payment_method` varchar(255) DEFAULT NULL,
  `date` date NOT NULL,
  `notes` text DEFAULT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `model_id` bigint(20) unsigned DEFAULT NULL,
  `model_type` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_wallet_transactions_customer_id_foreign` (`customer_id`),
  KEY `customer_wallet_transactions_user_id_foreign` (`user_id`),
  CONSTRAINT `customer_wallet_transactions_customer_id_foreign` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`id`) ON DELETE CASCADE,
  CONSTRAINT `customer_wallet_transactions_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customer_wallet_transactions`
--

LOCK TABLES `customer_wallet_transactions` WRITE;
/*!40000 ALTER TABLE `customer_wallet_transactions` DISABLE KEYS */;
INSERT INTO `customer_wallet_transactions` VALUES (1,22,'deposit',1000.00,'ندقى','2026-02-06','تست',1,NULL,NULL,'2026-02-06 15:30:34','2026-02-06 15:30:34');
/*!40000 ALTER TABLE `customer_wallet_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `customer_number` varchar(255) DEFAULT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `whmcs_id` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `avatar` varchar(255) DEFAULT NULL,
  `email` varchar(255) NOT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `whatsapp` varchar(50) DEFAULT NULL,
  `company` varchar(255) DEFAULT NULL,
  `commercial_register` varchar(255) DEFAULT NULL,
  `tax_id` varchar(255) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `status` enum('active','inactive','suspended') NOT NULL DEFAULT 'active',
  `customer_type` enum('individual','company') NOT NULL DEFAULT 'individual',
  `source` varchar(100) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `opening_balance` decimal(15,2) NOT NULL DEFAULT 0.00,
  `balance` decimal(15,2) NOT NULL DEFAULT 0.00,
  `portal_token` varchar(64) DEFAULT NULL,
  `portal_token_created_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `customer_group_id` bigint(20) unsigned DEFAULT NULL,
  `loyalty_enabled` tinyint(1) NOT NULL DEFAULT 0,
  `loyalty_points` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`),
  UNIQUE KEY `customers_portal_token_unique` (`portal_token`),
  UNIQUE KEY `customers_customer_number_unique` (`customer_number`),
  KEY `customers_whmcs_id_index` (`whmcs_id`),
  KEY `customers_email_index` (`email`),
  KEY `customers_status_index` (`status`),
  KEY `customers_user_id_foreign` (`user_id`),
  KEY `customers_customer_number_index` (`customer_number`),
  CONSTRAINT `customers_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'10000',1,NULL,'محمود منصور',NULL,'mahmoud@sog.eg','00201119060707','00201119060707','Smart One Group',NULL,NULL,'دمنهور - ش عبدالسلام الشذلى برج العلا','البحيره','مصر','active','company','manual','Test',0.00,0.00,'q4uiDEk4baLQZlwPzo63Wnf1BhdGAdQFlsg2I6eXGnnxxmYB1aP60axV6ona','2026-02-03 19:08:48','2026-02-03 19:08:48','2026-02-03 19:20:08',NULL,NULL,0,0.00),(2,'10001',1,1,'Mahmoud elsayed','avatars/phtateQJladzz3gnE8TQRGJEljf79PF9RDvTJZIb.png','Mahmoud@msktec.com',NULL,NULL,'MSKTEC',NULL,NULL,'',NULL,NULL,'active','company','whmcs',NULL,10000.00,10000.00,'FeIqbaKVcGVgxVoM1kYFHw0dLAsxg7MB8NZgvDEQHP8s3jW4Jf84mrzhIPCB','2026-02-04 17:17:54','2026-02-04 17:17:54','2026-02-04 23:35:47',NULL,NULL,1,0.00),(3,'35',1,35,'Maneam ',NULL,'gm@2me.com.eg',NULL,NULL,'2me Sport',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'Ss57XBYU8qW4QM5kNeXbFLbm96eKwSRpXU4CvDCsOcbhDAq9k7Rjdc833BK5','2026-02-04 23:35:46','2026-02-04 23:35:46','2026-02-04 23:35:46',NULL,NULL,0,0.00),(4,'102',1,102,'Abdulaziz Abdullah',NULL,'helpq825@yahoo.com',NULL,NULL,'مكتب الاتحاد لتدقيق الحسابات',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'h3JrNyWZcbvqd5CzRaKsbd9qwVfFQxXeKn5v1Wn9evCWOuVQiCgYPzvCQmSJ','2026-02-04 23:35:46','2026-02-04 23:35:46','2026-02-04 23:35:46',NULL,NULL,0,0.00),(5,'71',1,71,'Reham Adel',NULL,'r.rehamadel@yahoo.com',NULL,NULL,'Agro nile food',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'x17jq0zoCdaJhMmAXQieOFW1vE1WuFLR7AKlknHqfYH4w03TTWF8buw30wLa','2026-02-04 23:35:46','2026-02-04 23:35:46','2026-02-04 23:35:46',NULL,NULL,0,0.00),(6,'37',1,37,'Adel AhGroupEgypt',NULL,'adel@ahgroupegypt.com',NULL,NULL,'AhGroupEgypt',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'9D6j8X8SljgeL1lsFiCVYqcerQCUBXaxiG4x0VqQ2haymN24rULoG1Uv4S2x','2026-02-04 23:35:46','2026-02-04 23:35:46','2026-02-04 23:35:46',NULL,NULL,0,0.00),(7,'84',1,84,'ahmed Badawy',NULL,'Info@elgehaa.com',NULL,NULL,'Elgehaa',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'5oxIa7pRchxny6JadGErcvcmaD0iRKDcinjicgeDFs7WQ4TfcJrtJ499i6wV','2026-02-04 23:35:46','2026-02-04 23:35:46','2026-02-04 23:35:46',NULL,NULL,0,0.00),(8,'70',1,70,'mohamed bagaar',NULL,'mubaagar_2@hotmail.com',NULL,NULL,'bagaartools',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'rPacNTHeIBEOcUKGxtbgdo3mXwP97tRqpioenG8vAxRLlvsLxuW4I2yL5M34','2026-02-04 23:35:46','2026-02-04 23:35:46','2026-02-04 23:35:46',NULL,NULL,0,0.00),(9,'101',1,101,'AHMED BARAKAR',NULL,'engahmedbatkat@yahoo.com',NULL,NULL,'دراجو للمقاولات العامه',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'HFkJ1vV42rqptmt847W2FkGi0MV6ZDuAIlXSH7Lf5CiBxzRKivvMBj49LSmc','2026-02-04 23:35:46','2026-02-04 23:35:46','2026-02-04 23:35:46',NULL,NULL,0,0.00),(10,'36',1,36,'Ammar bdellateef',NULL,'info@ammarabdellateefinnovations.com',NULL,NULL,'ammara bdellateef innovations',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'CdKSphoRT0dsDg5NVHIaJvW0cnmI6OVf4oKNIxDXaJIsQFHf3I6H0sAXf03V','2026-02-04 23:35:46','2026-02-04 23:35:46','2026-02-04 23:35:46',NULL,NULL,0,0.00),(11,'90',1,90,'Mahmoud Delab',NULL,'mahmouddelaab3@gmail.com',NULL,NULL,'MD Company',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'i4qcXKjTptLYzI6cKcvMVw4iqTpFgku1H8QMWoWwlgow5FrmCsjR1eW1wO5R','2026-02-04 23:35:46','2026-02-04 23:35:46','2026-02-04 23:35:46',NULL,NULL,0,0.00),(12,'6',1,6,'eagleast.com eagleast.com',NULL,'info@eagleast.com',NULL,NULL,'eagleast',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'WNw2udpEgTkg4dBxM5YORu40jcNF5lzqrnZsEUlrW7BPe0pMnCUtC8k3tojm','2026-02-04 23:35:46','2026-02-04 23:35:46','2026-02-04 23:35:46',NULL,NULL,0,0.00),(13,'56',1,56,'Hazim Elabd',NULL,'hazimp@gmail.com',NULL,NULL,'speedcode',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'88KdA4iQbS5XRVsO1EojnAJiGvThjFQzzxWOtVvLBlbsmfGkmnNCbbAzAHa1','2026-02-04 23:35:46','2026-02-04 23:35:46','2026-02-04 23:35:46',NULL,NULL,0,0.00),(14,'8',1,8,'Medhat Elballat',NULL,'info@et.com.eg',NULL,NULL,'Elballat Trucks',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'gW7HiEZlhX35q78oBI9Ihz7twQTyl8SdLzyERhkBEvATuWw2bVvZWEs6ascc','2026-02-04 23:35:46','2026-02-04 23:35:46','2026-02-04 23:35:46',NULL,NULL,0,0.00),(15,'94',1,94,'mohamed elgendy',NULL,'mohamedelgendybrand@gmail.com',NULL,NULL,'Elgendy-Group',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'uV6CTI2O2TXmgR6sHkoT7hq99omNQBfWTPnellYBDFq0VqMIyTT6lFWpG3E4','2026-02-04 23:35:46','2026-02-04 23:35:46','2026-02-04 23:35:46',NULL,NULL,0,0.00),(16,'10',1,10,'Ahmed ElGhoul',NULL,'support@alrehabgp.com',NULL,NULL,'AlrehabGroup',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'45DuUj6kgOttZyapPbi5XcKV1fZnaHGuH4r8G3Oepv8hqIVMKvNLldVUGIV7','2026-02-04 23:35:46','2026-02-04 23:35:46','2026-02-04 23:35:46',NULL,NULL,0,0.00),(17,'88',1,88,'Mohamed  Elkardawy ',NULL,'m.elsayed.gr@gmail.com',NULL,NULL,'',NULL,NULL,'',NULL,NULL,'inactive','individual','whmcs',NULL,0.00,0.00,'SfmyiAIPQS8aGgRiaOiCkmrJRx6ugLqC57WuZEgck3wHTNMaWInZUD8eN6z7','2026-02-04 23:35:46','2026-02-04 23:35:46','2026-02-04 23:35:46',NULL,NULL,0,0.00),(18,'16',1,16,'Mohamed Elkharashy',NULL,'elkharashy2007@gmail.com',NULL,NULL,'Onfire Burger',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'7o1N7vM3ddMC5k3b5PyEkgOy7DVKwNaohjlIRyFyVV4iSFB7dS2wTaTIOuwB','2026-02-04 23:35:46','2026-02-04 23:35:46','2026-02-04 23:35:46',NULL,NULL,0,0.00),(19,'76',1,76,'Mohamed Elmaghraby',NULL,'mohamed94149470@icloud.com',NULL,NULL,'بيت العابنا',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'Ly1wzZy96YHAhcSQTQ2QQNZU5VGTdc3AR1ltBlVeccTyInh1nRhKWolpdVan','2026-02-04 23:35:46','2026-02-04 23:35:46','2026-02-04 23:35:46',NULL,NULL,0,0.00),(20,'95',1,95,'Ashraf ElQisar',NULL,'7okaa.it@gmail.com',NULL,NULL,'القيصر',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'s0BaFjdXdB4w0rOx3bO1PPBbZM2Hu90JlRvy9vdrjmWZulyBCIroDP3UlA12','2026-02-04 23:35:46','2026-02-04 23:35:46','2026-02-04 23:35:46',NULL,NULL,0,0.00),(21,'98',1,98,'Ehab Elrashedy',NULL,'elrashedysprocket871@gmail.com',NULL,NULL,'Elrashedy ',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'AGA2U7rjkqxCaX5vYYPNuSC7snx9zJgSvzV89q76lHTYKWsAyiNktLNJrwG4','2026-02-04 23:35:46','2026-02-04 23:35:46','2026-02-04 23:35:46',NULL,NULL,0,0.00),(22,'78',1,78,'Amr Elsanhoury',NULL,'amr.elsanhoury@outlook.com',NULL,NULL,'TRIPACKGROUP',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,1000.00,'tR77HmCl6tgRcfUf1tx34rarvyoTF0Q039n72grGRZ0TxTT0L5KM7yX3tWaQ','2026-02-04 23:35:47','2026-02-04 23:35:47','2026-02-06 15:30:34',NULL,NULL,0,0.00),(23,'14',1,14,'Gaber Elshemy',NULL,'gabershemy@gmail.com',NULL,NULL,'المبتكر العربي للبرمجيات',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'Z4FpiGG00qkAKrz3ec8Im25NRl1KXVMg1xXjFY5awxQGSkD0npYdhGrcBaTB','2026-02-04 23:35:47','2026-02-04 23:35:47','2026-02-04 23:35:47',NULL,NULL,0,0.00),(24,'58',1,58,'Mohamed Eltedawy',NULL,'mohamed.eltedawy@eliteservices-int.com',NULL,NULL,'Eliteservices',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'scmBS8V594ALLkwGoCq3VPbbo3OhmKh1V6beVUQeVmbHNWPCt8teSrKHFROi','2026-02-04 23:35:47','2026-02-04 23:35:47','2026-02-04 23:35:47',NULL,NULL,0,0.00),(25,'38',1,38,'Mohamed Elzokm',NULL,'Zokmzokm00@gmail.com',NULL,NULL,'عيادات دكتور محمد الزقم',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'VEdGbk3MvUdrFaO9iMtp2KfxvOm6DMtR17OlWMAQ4TBYJ1Rv46q4eVyqGuW2','2026-02-04 23:35:47','2026-02-04 23:35:47','2026-02-04 23:35:47',NULL,NULL,0,0.00),(26,'83',1,83,'fayrouz Export',NULL,'info@fayrouzex.com',NULL,NULL,'fayrouzex',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'SJv7XaUklhqtphrH1cQqKx79c5hl3NzOVCRih3U5iUeRS9ZCSveMSK4OLMht','2026-02-04 23:35:47','2026-02-04 23:35:47','2026-02-04 23:35:47',NULL,NULL,0,0.00),(27,'17',1,17,'Ahmed Fouad',NULL,'change.your.system@gmail.com',NULL,NULL,'مفاهيم التصميم للمقاولات',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'J6Itz46miAneEhXQOa1S70SXF4ynGfTuJZLTh9kJ1Ixox6uM5wZhZsFFJ00v','2026-02-04 23:35:47','2026-02-04 23:35:47','2026-02-04 23:35:47',NULL,NULL,0,0.00),(28,'82',1,82,'Fathi Glal',NULL,'info@hiexpresseg.com',NULL,NULL,'Hi Express',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'CVpUeT8gR21sP7uxKj9QIzjziYwLmNz76P8CeXJnN1mkri86Sx4yJIsXhMFj','2026-02-04 23:35:47','2026-02-04 23:35:47','2026-02-04 23:35:47',NULL,NULL,0,0.00),(29,'99',1,99,'Islam Harhash',NULL,'Info@metro-adv.com',NULL,NULL,'metro-adv',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'eoflnhJ6bisf8046HUxY6tlngSddpY0bWmd3dNCJW8lkUHYya2dLFAM8XZkf','2026-02-04 23:35:47','2026-02-04 23:35:47','2026-02-04 23:35:47',NULL,NULL,0,0.00),(30,'50',1,50,'Adel Hasaballah',NULL,'adelhasaballah2021@gmail.com',NULL,NULL,'Chart Marketing Agency',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'rILcVjbOoljrQHUNY0Sxjcc1S0CA6AW9DU8agacV4fpGhknCz7BZHJZl2Sr7','2026-02-04 23:35:47','2026-02-04 23:35:47','2026-02-04 23:35:47',NULL,NULL,0,0.00),(31,'97',1,97,'Yehia Hassan',NULL,'yyehiiaa@gmail.com',NULL,NULL,'',NULL,NULL,'',NULL,NULL,'inactive','individual','whmcs',NULL,0.00,0.00,'VaWXo5ClK5FO15I8i6fD9rV2TpqGPKsZvAzHWsQ8lpi0lbPkWs8vLJd8zxZE','2026-02-04 23:35:47','2026-02-04 23:35:47','2026-02-04 23:35:47',NULL,NULL,0,0.00),(32,'40',1,40,'Mohamed Mahdy',NULL,'m.mahdy.10000@gmail.com',NULL,NULL,'Impact Agancy',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'yeimW2MfZwMLL3kfEBLAwfKAjCmgn45el3FqzFKyXxMCqSsFJwc7VwmX6pXm','2026-02-04 23:35:47','2026-02-04 23:35:47','2026-02-04 23:35:47',NULL,NULL,0,0.00),(33,'100',1,100,'Hamza Malek',NULL,'hamzaebrahimabdelmoneam@gmail.com',NULL,NULL,'Vex',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'aNQTDVWpZHfl4Y1rf1hOYT2fm6d8yjWQ97QVCBATVzpf5s0kqzUv1jDt81VQ','2026-02-04 23:35:47','2026-02-04 23:35:47','2026-02-04 23:35:47',NULL,NULL,0,0.00),(34,'23',1,23,'Sherif Mamdoh',NULL,'sherif-mamdouh@outlook.com',NULL,NULL,'MOM',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'unOxuX3FHdHgeh9etOkk61AsOy9LJzl82ca7l83JxHaaugowOxi3BY7cgwLq','2026-02-04 23:35:47','2026-02-04 23:35:47','2026-02-04 23:35:47',NULL,NULL,0,0.00),(35,'41',1,41,'Mahmuod Mansour',NULL,'mahmoud.icp@gmail.com',NULL,NULL,'Smart One Group',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'h9FPmUHsXM7mJjCosXUeEZJ5uUsFK8iSe0UCvmWq9MKDAxbzB5EgSgvh87SV','2026-02-04 23:35:47','2026-02-04 23:35:47','2026-02-04 23:35:47',NULL,NULL,0,0.00),(36,'103',1,103,'Ali Mohamed',NULL,'ali@almehdar.co',NULL,NULL,'almehdar',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'ngBcUXCqgexh5DCzuyR3q1MLgwJdmNlww5s6eL4BtiNuy7Tf2at3YTSXvy49','2026-02-04 23:35:47','2026-02-04 23:35:47','2026-02-04 23:35:47',NULL,NULL,0,0.00),(37,'85',1,85,'eslam Naem',NULL,'info@elsharqion-plast.com',NULL,NULL,'elsharqion-plast',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'UBAxPxtCfazT6mzoZdURFJNAMs5o0lNBXY7pNy7GNzEWmnzAHppxp0AVyhdW','2026-02-04 23:35:47','2026-02-04 23:35:47','2026-02-04 23:35:47',NULL,NULL,0,0.00),(38,'63',1,63,'Mina  Nasef',NULL,'menanasef_4@yahoo.com',NULL,NULL,'عيادات دكتور مينا ناصف',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'ti0uN1iaje18JVN9W0Ff3ek7777HbeHfX9W4BNU6EeZCiTu4UMmrF6u4jbGM','2026-02-04 23:35:47','2026-02-04 23:35:47','2026-02-04 23:35:47',NULL,NULL,0,0.00),(39,'89',1,89,'el sayed rashed',NULL,'damanhour.orabi.shop@gmail.com',NULL,NULL,'connect',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'IXkztBev2hhcKgO4Rvezi25sMYM2CBX7cldxJ433MZFXMe5iW0tGEplYEWmf','2026-02-04 23:35:47','2026-02-04 23:35:47','2026-02-04 23:35:47',NULL,NULL,0,0.00),(40,'49',1,49,'Adel Sakar',NULL,'Mr.block3r@gmail.com',NULL,NULL,'Shark',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'g763epJlDWxxao1JtzYVO9X4ljeFXzBcibgqNvOjALmxdaT7ego1iLOWck4I','2026-02-04 23:35:47','2026-02-04 23:35:47','2026-02-04 23:35:47',NULL,NULL,0,0.00),(41,'5',1,5,'Doctor Salama',NULL,'info@smart1.co',NULL,NULL,'salamahealthstation',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'FWWNNsesAkegOEeOelfP8quCAKeICaWEqtybzXzUfc6n1WwLKidU4TOYmmjy','2026-02-04 23:35:47','2026-02-04 23:35:47','2026-02-04 23:35:47',NULL,NULL,0,0.00),(42,'51',1,51,'Ebrahim Samir',NULL,'Dr.math.eg@gmail.com',NULL,NULL,'Dr Math',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'qpr1kMnhTXmvbS94Tv0rc52oYGBzM6TwwE5FYCF1VqPVOnjodgihmhBGMDRO','2026-02-04 23:35:47','2026-02-04 23:35:47','2026-02-04 23:35:47',NULL,NULL,0,0.00),(43,'81',1,81,'Canary School',NULL,'Info@canary-school.com',NULL,NULL,'Canary school',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'FebMBTVWOl4hFVz94aMlBYMTyN0iqcuVGoBYaWIw4ib8RQFMyylAuKvdVIA2','2026-02-04 23:35:47','2026-02-04 23:35:47','2026-02-04 23:35:47',NULL,NULL,0,0.00),(44,'55',1,55,'Mohamed Shabban',NULL,'Mohamed.shaban.info@gmail.com',NULL,NULL,'vivarte',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'xlQPGpSoZB6kgSpGeH1pbpMEKNIAeRqAKU2yXDO9Wg44gAXzCSiLOxAmMvL5','2026-02-04 23:35:47','2026-02-04 23:35:47','2026-02-04 23:35:47',NULL,NULL,0,0.00),(45,'46',1,46,'Ebrahim Sobhy',NULL,'info@esm.best',NULL,NULL,'ESM Marketing',NULL,NULL,'',NULL,NULL,'active','individual','whmcs',NULL,0.00,0.00,'QF1tpMk1oGvNXe1c2FWuVZfYc5vGCzfLddWoK2yOvGtHdGnTsJGFW2TELggn','2026-02-04 23:35:47','2026-02-04 23:35:47','2026-02-04 23:35:47',NULL,NULL,0,0.00);
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `departments`
--

DROP TABLE IF EXISTS `departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `departments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `manager_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `departments`
--

LOCK TABLES `departments` WRITE;
/*!40000 ALTER TABLE `departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `designations`
--

DROP TABLE IF EXISTS `designations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `designations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `level` int(11) NOT NULL DEFAULT 1,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `designations`
--

LOCK TABLES `designations` WRITE;
/*!40000 ALTER TABLE `designations` DISABLE KEYS */;
/*!40000 ALTER TABLE `designations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `email_templates`
--

DROP TABLE IF EXISTS `email_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `email_templates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `subject` varchar(500) NOT NULL,
  `body` text NOT NULL,
  `type` varchar(100) DEFAULT NULL,
  `variables` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`variables`)),
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `email_templates`
--

LOCK TABLES `email_templates` WRITE;
/*!40000 ALTER TABLE `email_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `email_templates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `employees`
--

DROP TABLE IF EXISTS `employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `employees` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `job_title` varchar(255) NOT NULL,
  `department` varchar(255) DEFAULT NULL,
  `basic_salary` decimal(10,2) NOT NULL DEFAULT 0.00,
  `hire_date` date DEFAULT NULL,
  `status` varchar(255) NOT NULL DEFAULT 'active',
  `notes` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `department_id` bigint(20) unsigned DEFAULT NULL,
  `designation_id` bigint(20) unsigned DEFAULT NULL,
  `joining_date` date DEFAULT NULL,
  `hourly_rate` decimal(10,2) NOT NULL DEFAULT 0.00,
  `shift_type` varchar(255) NOT NULL DEFAULT 'day',
  `address` text DEFAULT NULL,
  `emergency_contact` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `employees_email_unique` (`email`),
  KEY `employees_department_id_foreign` (`department_id`),
  KEY `employees_designation_id_foreign` (`designation_id`),
  CONSTRAINT `employees_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE SET NULL,
  CONSTRAINT `employees_designation_id_foreign` FOREIGN KEY (`designation_id`) REFERENCES `designations` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `employees`
--

LOCK TABLES `employees` WRITE;
/*!40000 ALTER TABLE `employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) NOT NULL,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `financial_categories`
--

DROP TABLE IF EXISTS `financial_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `financial_categories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` enum('income','expense') NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `financial_categories`
--

LOCK TABLES `financial_categories` WRITE;
/*!40000 ALTER TABLE `financial_categories` DISABLE KEYS */;
INSERT INTO `financial_categories` VALUES (1,'Test Income Category','income','Test','2026-02-03 17:22:35','2026-02-03 17:22:35'),(2,'Test Expense Category','expense','Test','2026-02-03 17:22:35','2026-02-03 17:22:35');
/*!40000 ALTER TABLE `financial_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `financial_transactions`
--

DROP TABLE IF EXISTS `financial_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `financial_transactions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `treasury_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned DEFAULT NULL,
  `project_id` bigint(20) unsigned DEFAULT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `currency_id` bigint(20) unsigned DEFAULT NULL,
  `exchange_rate` decimal(15,6) NOT NULL DEFAULT 1.000000,
  `type` enum('in','out') NOT NULL,
  `date` date NOT NULL,
  `description` text DEFAULT NULL,
  `ref_no` varchar(255) DEFAULT NULL,
  `model_type` varchar(255) DEFAULT NULL,
  `model_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `financial_transactions_treasury_id_foreign` (`treasury_id`),
  KEY `financial_transactions_category_id_foreign` (`category_id`),
  KEY `financial_transactions_user_id_foreign` (`user_id`),
  KEY `financial_transactions_model_type_model_id_index` (`model_type`,`model_id`),
  KEY `financial_transactions_project_id_foreign` (`project_id`),
  KEY `financial_transactions_currency_id_foreign` (`currency_id`),
  CONSTRAINT `financial_transactions_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `financial_categories` (`id`) ON DELETE SET NULL,
  CONSTRAINT `financial_transactions_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `financial_transactions_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE SET NULL,
  CONSTRAINT `financial_transactions_treasury_id_foreign` FOREIGN KEY (`treasury_id`) REFERENCES `financial_treasuries` (`id`),
  CONSTRAINT `financial_transactions_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `financial_transactions`
--

LOCK TABLES `financial_transactions` WRITE;
/*!40000 ALTER TABLE `financial_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `financial_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `financial_treasuries`
--

DROP TABLE IF EXISTS `financial_treasuries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `financial_treasuries` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` enum('cash','bank','wallet') NOT NULL DEFAULT 'cash',
  `currency_id` bigint(20) unsigned DEFAULT NULL,
  `currency` varchar(10) NOT NULL DEFAULT 'EGP',
  `balance` decimal(15,2) NOT NULL DEFAULT 0.00,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `financial_treasuries_currency_id_foreign` (`currency_id`),
  CONSTRAINT `financial_treasuries_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `financial_treasuries`
--

LOCK TABLES `financial_treasuries` WRITE;
/*!40000 ALTER TABLE `financial_treasuries` DISABLE KEYS */;
INSERT INTO `financial_treasuries` VALUES (1,'Etisalat Cash (01119060707)','wallet',NULL,'EGP',0.00,1,'2026-02-03 17:14:46','2026-02-03 17:14:46'),(2,'درج المكتب','cash',NULL,'EGP',0.00,1,'2026-02-03 17:19:07','2026-02-04 17:43:30'),(3,'بنك CIB personal','bank',NULL,'EGP',0.00,1,'2026-02-04 17:43:54','2026-02-04 17:43:54'),(4,'Vodafone Cash (01032904040)','wallet',NULL,'EGP',0.00,1,'2026-02-04 17:44:16','2026-02-04 17:44:41');
/*!40000 ALTER TABLE `financial_treasuries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `investors`
--

DROP TABLE IF EXISTS `investors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `investors` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `total_shares` int(11) NOT NULL DEFAULT 0,
  `total_investment` decimal(15,2) NOT NULL DEFAULT 0.00,
  `avg_purchase_price` decimal(15,2) NOT NULL DEFAULT 0.00,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `investors`
--

LOCK TABLES `investors` WRITE;
/*!40000 ALTER TABLE `investors` DISABLE KEYS */;
/*!40000 ALTER TABLE `investors` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoice_items`
--

DROP TABLE IF EXISTS `invoice_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint(20) unsigned NOT NULL,
  `description` varchar(255) NOT NULL,
  `unit_id` bigint(20) unsigned DEFAULT NULL,
  `quantity` decimal(10,2) NOT NULL,
  `unit_price` decimal(15,2) NOT NULL,
  `total` decimal(15,2) NOT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `serial_key` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_items_invoice_id_foreign` (`invoice_id`),
  KEY `invoice_items_unit_id_foreign` (`unit_id`),
  CONSTRAINT `invoice_items_invoice_id_foreign` FOREIGN KEY (`invoice_id`) REFERENCES `invoices` (`id`) ON DELETE CASCADE,
  CONSTRAINT `invoice_items_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `units` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoice_items`
--

LOCK TABLES `invoice_items` WRITE;
/*!40000 ALTER TABLE `invoice_items` DISABLE KEYS */;
INSERT INTO `invoice_items` VALUES (1,1,'دعم فنى وظبط سرعه موقع القاضى',NULL,1.00,6000.00,6000.00,NULL,NULL,NULL,'2026-02-05 17:59:10','2026-02-05 17:59:10');
/*!40000 ALTER TABLE `invoice_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices`
--

DROP TABLE IF EXISTS `invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoices` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `whmcs_id` bigint(20) unsigned DEFAULT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  `currency_id` bigint(20) unsigned DEFAULT NULL,
  `exchange_rate` decimal(15,6) NOT NULL DEFAULT 1.000000,
  `project_id` bigint(20) unsigned DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `status` enum('draft','sent','partial','paid','cancelled') NOT NULL DEFAULT 'draft',
  `date` date NOT NULL,
  `due_date` date DEFAULT NULL,
  `subtotal` decimal(15,2) NOT NULL DEFAULT 0.00,
  `tax_percent` decimal(5,2) NOT NULL DEFAULT 14.00,
  `tax_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `discount_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `total` decimal(15,2) NOT NULL DEFAULT 0.00,
  `paid_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `notes` text DEFAULT NULL,
  `uuid` varchar(255) DEFAULT NULL COMMENT 'For E-Invoice ETA',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `sales_person_id` bigint(20) unsigned DEFAULT NULL,
  `commission_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `loyalty_points_redeemed` decimal(15,2) NOT NULL DEFAULT 0.00,
  `loyalty_amount_redeemed` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`),
  UNIQUE KEY `invoices_code_unique` (`code`),
  UNIQUE KEY `invoices_whmcs_id_unique` (`whmcs_id`),
  KEY `invoices_customer_id_foreign` (`customer_id`),
  KEY `invoices_sales_person_id_foreign` (`sales_person_id`),
  KEY `invoices_project_id_foreign` (`project_id`),
  KEY `invoices_currency_id_foreign` (`currency_id`),
  CONSTRAINT `invoices_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `invoices_customer_id_foreign` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`id`),
  CONSTRAINT `invoices_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE SET NULL,
  CONSTRAINT `invoices_sales_person_id_foreign` FOREIGN KEY (`sales_person_id`) REFERENCES `sales_people` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices`
--

LOCK TABLES `invoices` WRITE;
/*!40000 ALTER TABLE `invoices` DISABLE KEYS */;
INSERT INTO `invoices` VALUES (1,NULL,2,1,1.000000,3,'INV-2026-0001','partial','2026-02-05','2026-02-17',6000.00,0.00,0.00,0.00,6000.00,5000.00,'فاتورة للمشروع: دعم فنى وظبط سرعه موقع القاضى',NULL,'2026-02-05 17:59:10','2026-02-06 15:32:52',NULL,0.00,0.00,0.00);
/*!40000 ALTER TABLE `invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `job_batches`
--

DROP TABLE IF EXISTS `job_batches`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `job_batches` (
  `id` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `total_jobs` int(11) NOT NULL,
  `pending_jobs` int(11) NOT NULL,
  `failed_jobs` int(11) NOT NULL,
  `failed_job_ids` longtext NOT NULL,
  `options` mediumtext DEFAULT NULL,
  `cancelled_at` int(11) DEFAULT NULL,
  `created_at` int(11) NOT NULL,
  `finished_at` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `job_batches`
--

LOCK TABLES `job_batches` WRITE;
/*!40000 ALTER TABLE `job_batches` DISABLE KEYS */;
/*!40000 ALTER TABLE `job_batches` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) NOT NULL,
  `payload` longtext NOT NULL,
  `attempts` tinyint(3) unsigned NOT NULL,
  `reserved_at` int(10) unsigned DEFAULT NULL,
  `available_at` int(10) unsigned NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `journal_entries`
--

DROP TABLE IF EXISTS `journal_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `journal_entries` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `reference` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_manual` tinyint(1) NOT NULL DEFAULT 1,
  `locked` tinyint(1) NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `journal_entries_user_id_foreign` (`user_id`),
  CONSTRAINT `journal_entries_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `journal_entries`
--

LOCK TABLES `journal_entries` WRITE;
/*!40000 ALTER TABLE `journal_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `journal_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `journal_entry_lines`
--

DROP TABLE IF EXISTS `journal_entry_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `journal_entry_lines` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `journal_entry_id` bigint(20) unsigned NOT NULL,
  `account_id` bigint(20) unsigned NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `journal_entry_lines_journal_entry_id_foreign` (`journal_entry_id`),
  KEY `journal_entry_lines_account_id_foreign` (`account_id`),
  CONSTRAINT `journal_entry_lines_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`),
  CONSTRAINT `journal_entry_lines_journal_entry_id_foreign` FOREIGN KEY (`journal_entry_id`) REFERENCES `journal_entries` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `journal_entry_lines`
--

LOCK TABLES `journal_entry_lines` WRITE;
/*!40000 ALTER TABLE `journal_entry_lines` DISABLE KEYS */;
/*!40000 ALTER TABLE `journal_entry_lines` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `loyalty_transactions`
--

DROP TABLE IF EXISTS `loyalty_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `loyalty_transactions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint(20) unsigned NOT NULL,
  `points` decimal(15,2) NOT NULL,
  `type` enum('earned','redeemed','adjustment','refund') NOT NULL,
  `reference_type` varchar(255) DEFAULT NULL,
  `reference_id` bigint(20) unsigned DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `loyalty_transactions_customer_id_foreign` (`customer_id`),
  KEY `loyalty_transactions_reference_type_reference_id_index` (`reference_type`,`reference_id`),
  CONSTRAINT `loyalty_transactions_customer_id_foreign` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `loyalty_transactions`
--

LOCK TABLES `loyalty_transactions` WRITE;
/*!40000 ALTER TABLE `loyalty_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `loyalty_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'0001_01_01_000000_create_users_table',1),(2,'0001_01_01_000001_create_cache_table',1),(3,'0001_01_01_000002_create_jobs_table',1),(4,'2026_02_01_000001_create_settings_table',1),(5,'2026_02_01_000002_create_customers_table',1),(6,'2026_02_01_000003_create_customer_notes_table',1),(7,'2026_02_01_000004_create_customer_documents_table',1),(8,'2026_02_01_000005_create_email_templates_table',1),(9,'2026_02_01_171857_create_permission_tables',2),(10,'2026_02_01_000006_create_accounting_basics_tables',3),(11,'2026_02_01_000007_create_financial_transactions_table',3),(12,'2026_02_01_000008_create_invoices_tables',3),(13,'2026_02_01_185252_create_products_table',4),(14,'2026_02_01_191441_create_suppliers_table',5),(15,'2026_02_01_191446_create_bills_table',5),(16,'2026_02_01_192445_create_recurring_invoices_table',6),(17,'2026_02_01_225408_create_accounts_table',7),(18,'2026_02_01_225417_create_journal_entries_table',7),(19,'2026_02_01_225421_create_journal_entry_lines_table',7),(20,'2026_02_01_231122_add_whmcs_id_to_invoices_table',8),(21,'2026_02_01_235013_create_partners_and_shares_tables',9),(22,'2026_02_02_001829_create_currencies_table',10),(23,'2026_02_02_001927_create_supplier_services_table',10),(24,'2026_02_02_003200_create_projects_table',11),(25,'2026_02_02_003218_create_programmer_payments_table',11),(26,'2026_02_02_005221_create_software_licenses_table',12),(27,'2026_02_02_005228_add_serial_key_to_invoice_items_table',12),(28,'2026_02_02_010715_create_sales_people_table',13),(29,'2026_02_02_010719_create_sales_commissions_table',13),(30,'2026_02_02_010722_create_sales_commission_payments_table',13),(31,'2026_02_02_010837_add_sales_commission_to_invoices_table',14),(32,'2026_02_02_174300_create_quotations_table',15),(33,'2026_02_02_174309_create_quotation_items_table',15),(34,'2026_02_02_190238_make_serial_key_nullable_in_invoice_items_table',16),(35,'2026_02_02_200000_create_subscriptions_table',17),(36,'2026_02_02_213000_create_employees_table',18),(37,'2026_02_02_220000_add_portal_token_to_customers_table',19),(38,'2026_02_03_145539_add_phone_and_otp_to_users_table',20),(39,'2026_02_03_150819_update_customers_phone_required',20),(40,'2026_02_03_175209_add_project_id_to_financial_transactions_table',21),(41,'2026_02_03_175806_add_project_id_to_invoices_table',22),(47,'2026_02_03_184453_create_customer_groups_table',23),(48,'2026_02_03_184454_add_loyalty_rate_to_currencies_table',23),(49,'2026_02_03_184454_create_loyalty_transactions_table',23),(50,'2026_02_03_184455_add_loyalty_redemption_to_invoices_table',23),(51,'2026_02_03_184500_add_loyalty_and_groups_to_customers_table',23),(52,'2026_02_03_201015_add_user_id_to_customers_table',24),(53,'2026_02_03_204518_add_balance_to_customers_table',25),(54,'2026_02_03_204520_create_customer_wallet_transactions_table',25),(55,'2026_02_03_205715_add_identity_fields_to_customers_table',26),(56,'2026_02_03_212716_add_avatar_to_customers_table',27),(57,'2026_02_03_212827_create_tickets_table',27),(58,'2026_02_03_212850_create_ticket_messages_table',27),(59,'2026_02_04_000002_create_whmcs_import_queue_table',28),(60,'2026_02_04_000003_create_units_tables',28),(61,'2026_02_04_000004_create_warehouses_table',29),(62,'2026_02_04_000005_create_hr_structure_tables',30),(63,'2026_02_04_000006_create_payroll_attendance_tables',31),(64,'2026_02_04_212500_add_invoice_id_to_projects_table',32),(65,'2026_02_04_230000_add_points_value_to_customer_groups_table',33),(66,'2026_02_04_233000_add_currency_columns_to_tables',34),(67,'2026_02_04_235000_add_currency_to_transactions_table',35),(68,'2026_02_05_000000_add_price_usd_to_products',36),(69,'2026_02_05_012258_make_whatsapp_nullable_in_customers_table',37),(70,'2026_02_05_013249_make_phone_nullable_in_customers_table',38),(71,'2026_02_05_132819_add_currency_and_balance_to_suppliers_table',39),(72,'2026_02_05_133059_add_currency_to_bills_table',40);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `model_has_permissions`
--

DROP TABLE IF EXISTS `model_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL,
  `model_type` varchar(255) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `model_has_permissions`
--

LOCK TABLES `model_has_permissions` WRITE;
/*!40000 ALTER TABLE `model_has_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `model_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `model_has_roles`
--

DROP TABLE IF EXISTS `model_has_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_roles` (
  `role_id` bigint(20) unsigned NOT NULL,
  `model_type` varchar(255) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `model_has_roles`
--

LOCK TABLES `model_has_roles` WRITE;
/*!40000 ALTER TABLE `model_has_roles` DISABLE KEYS */;
INSERT INTO `model_has_roles` VALUES (1,'App\\Models\\User',1),(1,'App\\Models\\User',4);
/*!40000 ALTER TABLE `model_has_roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `partners`
--

DROP TABLE IF EXISTS `partners`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `partners` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `ownership_percent` decimal(5,2) NOT NULL,
  `capital_invested` decimal(15,2) NOT NULL DEFAULT 0.00,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `partners`
--

LOCK TABLES `partners` WRITE;
/*!40000 ALTER TABLE `partners` DISABLE KEYS */;
INSERT INTO `partners` VALUES (1,'محمود منصور','mahmoud@sog.eg','00201119060707',80.00,80000.00,1,'2026-02-04 18:48:08','2026-02-04 18:49:52'),(2,'لوجه الله تعالى',NULL,NULL,10.00,10000.00,1,'2026-02-04 18:50:09','2026-02-04 18:50:09'),(3,'مالك وفريده',NULL,NULL,10.00,10000.00,1,'2026-02-04 18:50:36','2026-02-04 18:50:36');
/*!40000 ALTER TABLE `partners` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_reset_tokens`
--

DROP TABLE IF EXISTS `password_reset_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_reset_tokens`
--

LOCK TABLES `password_reset_tokens` WRITE;
/*!40000 ALTER TABLE `password_reset_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_reset_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payroll_items`
--

DROP TABLE IF EXISTS `payroll_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `payroll_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payroll_id` bigint(20) unsigned NOT NULL,
  `type` enum('allowance','deduction','bonus','penalty') NOT NULL,
  `description` varchar(255) NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payroll_items_payroll_id_foreign` (`payroll_id`),
  CONSTRAINT `payroll_items_payroll_id_foreign` FOREIGN KEY (`payroll_id`) REFERENCES `payrolls` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payroll_items`
--

LOCK TABLES `payroll_items` WRITE;
/*!40000 ALTER TABLE `payroll_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `payroll_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payrolls`
--

DROP TABLE IF EXISTS `payrolls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `payrolls` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `period_month` varchar(255) NOT NULL,
  `basic_salary` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_allowances` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_deductions` decimal(12,2) NOT NULL DEFAULT 0.00,
  `net_salary` decimal(12,2) NOT NULL DEFAULT 0.00,
  `status` enum('draft','approved','paid') NOT NULL DEFAULT 'draft',
  `payment_date` date DEFAULT NULL,
  `treasury_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payrolls_employee_id_foreign` (`employee_id`),
  CONSTRAINT `payrolls_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payrolls`
--

LOCK TABLES `payrolls` WRITE;
/*!40000 ALTER TABLE `payrolls` DISABLE KEYS */;
/*!40000 ALTER TABLE `payrolls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `permissions`
--

DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `guard_name` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `permissions_name_guard_name_unique` (`name`,`guard_name`)
) ENGINE=InnoDB AUTO_INCREMENT=127 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `permissions`
--

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES (1,'manage customers','web','2026-02-01 15:19:33','2026-02-01 15:19:33'),(2,'manage settings','web','2026-02-01 15:19:33','2026-02-01 15:19:33'),(3,'view dashboard','web','2026-02-01 15:19:33','2026-02-01 15:19:33'),(4,'view customers','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(5,'create customers','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(6,'edit customers','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(7,'delete customers','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(8,'full customers','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(9,'view companies','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(10,'create companies','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(11,'edit companies','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(12,'delete companies','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(13,'full companies','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(14,'view transactions','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(15,'create transactions','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(16,'edit transactions','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(17,'delete transactions','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(18,'full transactions','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(19,'view sales','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(20,'create sales','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(21,'edit sales','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(22,'delete sales','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(23,'full sales','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(24,'view treasuries','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(25,'create treasuries','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(26,'edit treasuries','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(27,'delete treasuries','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(28,'full treasuries','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(29,'view products','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(30,'create products','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(31,'edit products','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(32,'delete products','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(33,'full products','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(34,'view reports','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(35,'create reports','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(36,'edit reports','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(37,'delete reports','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(38,'full reports','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(39,'view utilities','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(40,'create utilities','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(41,'edit utilities','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(42,'delete utilities','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(43,'full utilities','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(44,'view appearance','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(45,'create appearance','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(46,'edit appearance','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(47,'delete appearance','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(48,'full appearance','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(49,'view plugins','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(50,'create plugins','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(51,'edit plugins','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(52,'delete plugins','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(53,'full plugins','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(54,'view calendar','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(55,'create calendar','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(56,'edit calendar','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(57,'delete calendar','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(58,'full calendar','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(59,'view leads','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(60,'create leads','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(61,'edit leads','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(62,'delete leads','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(63,'full leads','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(64,'view tasks','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(65,'create tasks','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(66,'edit tasks','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(67,'delete tasks','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(68,'full tasks','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(69,'view contracts','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(70,'create contracts','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(71,'edit contracts','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(72,'delete contracts','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(73,'full contracts','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(74,'view orders','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(75,'create orders','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(76,'edit orders','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(77,'delete orders','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(78,'full orders','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(79,'view settings','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(80,'create settings','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(81,'edit settings','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(82,'delete settings','web','2026-02-03 18:12:05','2026-02-03 18:12:05'),(83,'full settings','web','2026-02-03 18:12:06','2026-02-03 18:12:06'),(84,'view documents','web','2026-02-03 18:12:06','2026-02-03 18:12:06'),(85,'create documents','web','2026-02-03 18:12:06','2026-02-03 18:12:06'),(86,'edit documents','web','2026-02-03 18:12:06','2026-02-03 18:12:06'),(87,'delete documents','web','2026-02-03 18:12:06','2026-02-03 18:12:06'),(88,'full documents','web','2026-02-03 18:12:06','2026-02-03 18:12:06'),(89,'view loyalty','web','2026-02-03 18:18:56','2026-02-03 18:18:56'),(90,'create loyalty','web','2026-02-03 18:18:56','2026-02-03 18:18:56'),(91,'edit loyalty','web','2026-02-03 18:18:56','2026-02-03 18:18:56'),(92,'delete loyalty','web','2026-02-03 18:18:56','2026-02-03 18:18:56'),(93,'full loyalty','web','2026-02-03 18:18:56','2026-02-03 18:18:56'),(94,'view whmcs','web','2026-02-03 18:18:56','2026-02-03 18:18:56'),(95,'create whmcs','web','2026-02-03 18:18:56','2026-02-03 18:18:56'),(96,'edit whmcs','web','2026-02-03 18:18:56','2026-02-03 18:18:56'),(97,'delete whmcs','web','2026-02-03 18:18:56','2026-02-03 18:18:56'),(98,'full whmcs','web','2026-02-03 18:18:56','2026-02-03 18:18:56'),(99,'view sales_team','web','2026-02-03 18:18:56','2026-02-03 18:18:56'),(100,'create sales_team','web','2026-02-03 18:18:56','2026-02-03 18:18:56'),(101,'edit sales_team','web','2026-02-03 18:18:56','2026-02-03 18:18:56'),(102,'delete sales_team','web','2026-02-03 18:18:56','2026-02-03 18:18:56'),(103,'full sales_team','web','2026-02-03 18:18:56','2026-02-03 18:18:56'),(104,'view projects','web','2026-02-04 17:55:31','2026-02-04 17:55:31'),(105,'create projects','web','2026-02-04 17:55:31','2026-02-04 17:55:31'),(106,'edit projects','web','2026-02-04 17:55:31','2026-02-04 17:55:31'),(107,'delete projects','web','2026-02-04 17:55:31','2026-02-04 17:55:31'),(108,'full projects','web','2026-02-04 17:55:31','2026-02-04 17:55:31'),(109,'view invoices','web','2026-02-04 17:55:31','2026-02-04 17:55:31'),(110,'create invoices','web','2026-02-04 17:55:31','2026-02-04 17:55:31'),(111,'edit invoices','web','2026-02-04 17:55:31','2026-02-04 17:55:31'),(112,'delete invoices','web','2026-02-04 17:55:31','2026-02-04 17:55:31'),(113,'full invoices','web','2026-02-04 17:55:31','2026-02-04 17:55:31'),(114,'view attendance','web','2026-02-04 17:55:31','2026-02-04 17:55:31'),(115,'create attendance','web','2026-02-04 17:55:31','2026-02-04 17:55:31'),(116,'edit attendance','web','2026-02-04 17:55:31','2026-02-04 17:55:31'),(117,'delete attendance','web','2026-02-04 17:55:32','2026-02-04 17:55:32'),(118,'full attendance','web','2026-02-04 17:55:32','2026-02-04 17:55:32'),(119,'view payroll','web','2026-02-04 17:55:32','2026-02-04 17:55:32'),(120,'create payroll','web','2026-02-04 17:55:32','2026-02-04 17:55:32'),(121,'edit payroll','web','2026-02-04 17:55:32','2026-02-04 17:55:32'),(122,'delete payroll','web','2026-02-04 17:55:32','2026-02-04 17:55:32'),(123,'full payroll','web','2026-02-04 17:55:32','2026-02-04 17:55:32'),(124,'view own projects','web','2026-02-04 17:55:32','2026-02-04 17:55:32'),(125,'update own project progress','web','2026-02-04 17:55:32','2026-02-04 17:55:32'),(126,'view own payments','web','2026-02-04 17:55:32','2026-02-04 17:55:32');
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `products` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` enum('service','physical') NOT NULL DEFAULT 'physical',
  `unit_id` bigint(20) unsigned DEFAULT NULL,
  `sku` varchar(255) DEFAULT NULL,
  `price` decimal(10,2) NOT NULL DEFAULT 0.00,
  `price_usd` decimal(15,2) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `products_sku_unique` (`sku`),
  KEY `products_unit_id_foreign` (`unit_id`),
  CONSTRAINT `products_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `units` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'استضافه مشتركه الخطه الاولى 10GB','service',8,'001',3500.00,NULL,'مميزات الباقة\r\n✓	مساحة تخزينية 10 جيجا\r\nمناسبة للمواقع الخفيفة والمتوسطة\r\n✓	نقل بيانات غير محدود\r\nبدون حدود للترافيك الشهري\r\n✓	10 حسابات بريد إلكتروني\r\nبريد احترافي\r\n✓	جميع الخواص غير محدودة\r\nقواعد بيانات وFTP بلا حدود\r\n✓	لوحة تحكم cPanel بالعربية\r\nواجهة سهلة الاستخدام\r\n✗	مواقع متعددة\r\nغير متاح في هذه الباقة\r\n✗	اسم نطاق .com\r\nغير متاح في هذه الباقة\r\n✗	نسخ احتياطي شهري مجاني\r\nغير متاح في هذه الباقة\r\n✗	دعم فني مدفوع',1,'2026-02-06 15:39:12','2026-02-06 15:39:12'),(2,'تصميم موقع تعريفى لغه واحده لاندينج بيدج','service',9,'002',5000.00,NULL,'تصميم موقع الشركات البسيطه مكون من اقسام لصفحه واحده لغه واحده فقط',1,'2026-02-06 15:40:24','2026-02-06 15:40:24'),(3,'تنفيذ برنامج تجارى ( متوسط )','service',9,'003',15000.00,NULL,'تصميم برنامج بناء على متطلبات العميل لنشاط تجارى بلغه برمجه لارفل مع قواعد بيانات من نوع MYSQL يتم تنفيذه ليكون برنامج اون لاين مع دعم فنى لمده شهر من تاريخ التسليم ودعم فنى لمده 6 اشهر عن طريق تذاكر الدعم الفنى',1,'2026-02-06 15:41:58','2026-02-06 15:41:58');
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `profit_distributions`
--

DROP TABLE IF EXISTS `profit_distributions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `profit_distributions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `partner_id` bigint(20) unsigned DEFAULT NULL,
  `investor_id` bigint(20) unsigned DEFAULT NULL,
  `type` enum('partner','shareholder') NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `date` date NOT NULL,
  `period_start` date NOT NULL,
  `period_end` date NOT NULL,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `profit_distributions_partner_id_foreign` (`partner_id`),
  KEY `profit_distributions_investor_id_foreign` (`investor_id`),
  CONSTRAINT `profit_distributions_investor_id_foreign` FOREIGN KEY (`investor_id`) REFERENCES `investors` (`id`) ON DELETE SET NULL,
  CONSTRAINT `profit_distributions_partner_id_foreign` FOREIGN KEY (`partner_id`) REFERENCES `partners` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `profit_distributions`
--

LOCK TABLES `profit_distributions` WRITE;
/*!40000 ALTER TABLE `profit_distributions` DISABLE KEYS */;
/*!40000 ALTER TABLE `profit_distributions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `programmer_payments`
--

DROP TABLE IF EXISTS `programmer_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `programmer_payments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `project_id` bigint(20) unsigned NOT NULL,
  `programmer_id` bigint(20) unsigned NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `date` date NOT NULL,
  `notes` text DEFAULT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `programmer_payments_project_id_foreign` (`project_id`),
  KEY `programmer_payments_programmer_id_foreign` (`programmer_id`),
  KEY `programmer_payments_user_id_foreign` (`user_id`),
  CONSTRAINT `programmer_payments_programmer_id_foreign` FOREIGN KEY (`programmer_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `programmer_payments_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `programmer_payments_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `programmer_payments`
--

LOCK TABLES `programmer_payments` WRITE;
/*!40000 ALTER TABLE `programmer_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `programmer_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `projects` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  `programmer_id` bigint(20) unsigned NOT NULL,
  `total_price` decimal(15,2) NOT NULL,
  `commission_amount` decimal(15,2) NOT NULL,
  `progress_percent` int(11) NOT NULL DEFAULT 0,
  `status` enum('pending','in_progress','completed','cancelled','on_hold') NOT NULL DEFAULT 'pending',
  `invoice_id` bigint(20) unsigned DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `projects_customer_id_foreign` (`customer_id`),
  KEY `projects_programmer_id_foreign` (`programmer_id`),
  KEY `projects_invoice_id_foreign` (`invoice_id`),
  CONSTRAINT `projects_customer_id_foreign` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`id`) ON DELETE CASCADE,
  CONSTRAINT `projects_invoice_id_foreign` FOREIGN KEY (`invoice_id`) REFERENCES `invoices` (`id`) ON DELETE SET NULL,
  CONSTRAINT `projects_programmer_id_foreign` FOREIGN KEY (`programmer_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
INSERT INTO `projects` VALUES (3,'دعم فنى وظبط سرعه موقع القاضى',2,3,6000.00,3000.00,0,'pending',1,NULL,'2026-02-05','2026-02-17','2026-02-05 17:59:10','2026-02-05 17:59:10');
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotation_items`
--

DROP TABLE IF EXISTS `quotation_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `quotation_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `quotation_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned DEFAULT NULL,
  `description` varchar(255) NOT NULL,
  `unit_id` bigint(20) unsigned DEFAULT NULL,
  `quantity` decimal(10,2) NOT NULL,
  `unit_price` decimal(15,2) NOT NULL,
  `tax_rate` decimal(5,2) NOT NULL DEFAULT 0.00,
  `tax_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `total` decimal(15,2) NOT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `quotation_items_quotation_id_foreign` (`quotation_id`),
  KEY `quotation_items_product_id_foreign` (`product_id`),
  KEY `quotation_items_unit_id_foreign` (`unit_id`),
  CONSTRAINT `quotation_items_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE SET NULL,
  CONSTRAINT `quotation_items_quotation_id_foreign` FOREIGN KEY (`quotation_id`) REFERENCES `quotations` (`id`) ON DELETE CASCADE,
  CONSTRAINT `quotation_items_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `units` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotation_items`
--

LOCK TABLES `quotation_items` WRITE;
/*!40000 ALTER TABLE `quotation_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotation_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotations`
--

DROP TABLE IF EXISTS `quotations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `quotations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) NOT NULL,
  `quotation_number` varchar(255) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  `currency_id` bigint(20) unsigned DEFAULT NULL,
  `exchange_rate` decimal(15,6) NOT NULL DEFAULT 1.000000,
  `date` date NOT NULL,
  `expiry_date` date DEFAULT NULL,
  `status` enum('draft','sent','accepted','rejected','converted') NOT NULL DEFAULT 'draft',
  `subtotal` decimal(15,2) NOT NULL DEFAULT 0.00,
  `tax_total` decimal(15,2) NOT NULL DEFAULT 0.00,
  `discount_total` decimal(15,2) NOT NULL DEFAULT 0.00,
  `grand_total` decimal(15,2) NOT NULL DEFAULT 0.00,
  `notes` text DEFAULT NULL,
  `terms` text DEFAULT NULL,
  `converted_invoice_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `quotations_uuid_unique` (`uuid`),
  UNIQUE KEY `quotations_quotation_number_unique` (`quotation_number`),
  KEY `quotations_customer_id_foreign` (`customer_id`),
  KEY `quotations_converted_invoice_id_foreign` (`converted_invoice_id`),
  KEY `quotations_currency_id_foreign` (`currency_id`),
  CONSTRAINT `quotations_converted_invoice_id_foreign` FOREIGN KEY (`converted_invoice_id`) REFERENCES `invoices` (`id`) ON DELETE SET NULL,
  CONSTRAINT `quotations_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `quotations_customer_id_foreign` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotations`
--

LOCK TABLES `quotations` WRITE;
/*!40000 ALTER TABLE `quotations` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `recurring_invoices`
--

DROP TABLE IF EXISTS `recurring_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `recurring_invoices` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint(20) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `frequency` enum('daily','weekly','monthly','quarterly','yearly') NOT NULL,
  `start_date` date NOT NULL,
  `next_run_date` date NOT NULL,
  `end_date` date DEFAULT NULL,
  `amount` decimal(10,2) NOT NULL,
  `items` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`items`)),
  `notes` text DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `last_run_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recurring_invoices_customer_id_foreign` (`customer_id`),
  CONSTRAINT `recurring_invoices_customer_id_foreign` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `recurring_invoices`
--

LOCK TABLES `recurring_invoices` WRITE;
/*!40000 ALTER TABLE `recurring_invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `recurring_invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_has_permissions`
--

DROP TABLE IF EXISTS `role_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `role_has_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL,
  `role_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_has_permissions`
--

LOCK TABLES `role_has_permissions` WRITE;
/*!40000 ALTER TABLE `role_has_permissions` DISABLE KEYS */;
INSERT INTO `role_has_permissions` VALUES (1,1),(2,1),(3,1),(4,1),(5,1),(6,1),(7,1),(8,1),(9,1),(10,1),(11,1),(12,1),(13,1),(14,1),(15,1),(16,1),(17,1),(18,1),(19,1),(20,1),(21,1),(22,1),(23,1),(24,1),(25,1),(26,1),(27,1),(28,1),(29,1),(30,1),(31,1),(32,1),(33,1),(34,1),(35,1),(36,1),(37,1),(38,1),(39,1),(40,1),(41,1),(42,1),(43,1),(44,1),(45,1),(46,1),(47,1),(48,1),(49,1),(50,1),(51,1),(52,1),(53,1),(54,1),(55,1),(56,1),(57,1),(58,1),(59,1),(60,1),(61,1),(62,1),(63,1),(64,1),(65,1),(66,1),(67,1),(68,1),(69,1),(70,1),(71,1),(72,1),(73,1),(74,1),(75,1),(76,1),(77,1),(78,1),(79,1),(80,1),(81,1),(82,1),(83,1),(84,1),(85,1),(86,1),(87,1),(88,1),(89,1),(90,1),(91,1),(92,1),(93,1),(94,1),(95,1),(96,1),(97,1),(98,1),(99,1),(100,1),(101,1),(102,1),(103,1),(104,1),(105,1),(106,1),(107,1),(108,1),(109,1),(110,1),(111,1),(112,1),(113,1),(114,1),(115,1),(116,1),(117,1),(118,1),(119,1),(120,1),(121,1),(122,1),(123,1),(124,1),(124,3),(125,1),(125,3),(126,1),(126,3);
/*!40000 ALTER TABLE `role_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `roles` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `guard_name` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_name_guard_name_unique` (`name`,`guard_name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'admin','web','2026-02-01 15:19:33','2026-02-01 15:19:33'),(3,'programmer','web','2026-02-04 17:55:32','2026-02-04 17:55:32');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_commission_payments`
--

DROP TABLE IF EXISTS `sales_commission_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sales_commission_payments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sales_person_id` bigint(20) unsigned NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `date` date NOT NULL,
  `treasury_id` bigint(20) unsigned NOT NULL,
  `payment_method` varchar(255) NOT NULL DEFAULT 'cash',
  `notes` text DEFAULT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sales_commission_payments_sales_person_id_foreign` (`sales_person_id`),
  KEY `sales_commission_payments_treasury_id_foreign` (`treasury_id`),
  KEY `sales_commission_payments_user_id_foreign` (`user_id`),
  CONSTRAINT `sales_commission_payments_sales_person_id_foreign` FOREIGN KEY (`sales_person_id`) REFERENCES `sales_people` (`id`) ON DELETE CASCADE,
  CONSTRAINT `sales_commission_payments_treasury_id_foreign` FOREIGN KEY (`treasury_id`) REFERENCES `financial_treasuries` (`id`) ON DELETE CASCADE,
  CONSTRAINT `sales_commission_payments_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_commission_payments`
--

LOCK TABLES `sales_commission_payments` WRITE;
/*!40000 ALTER TABLE `sales_commission_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_commission_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_commissions`
--

DROP TABLE IF EXISTS `sales_commissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sales_commissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint(20) unsigned NOT NULL,
  `sales_person_id` bigint(20) unsigned NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `status` enum('pending','partial','paid') NOT NULL DEFAULT 'pending',
  `notes` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sales_commissions_invoice_id_foreign` (`invoice_id`),
  KEY `sales_commissions_sales_person_id_foreign` (`sales_person_id`),
  CONSTRAINT `sales_commissions_invoice_id_foreign` FOREIGN KEY (`invoice_id`) REFERENCES `invoices` (`id`) ON DELETE CASCADE,
  CONSTRAINT `sales_commissions_sales_person_id_foreign` FOREIGN KEY (`sales_person_id`) REFERENCES `sales_people` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_commissions`
--

LOCK TABLES `sales_commissions` WRITE;
/*!40000 ALTER TABLE `sales_commissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_commissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_people`
--

DROP TABLE IF EXISTS `sales_people`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sales_people` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `whatsapp` varchar(255) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_people`
--

LOCK TABLES `sales_people` WRITE;
/*!40000 ALTER TABLE `sales_people` DISABLE KEYS */;
INSERT INTO `sales_people` VALUES (1,'Mahmoud Mansour','01119060707','mahmoud@sog.eg','00201119060707',1,'2026-02-03 19:04:57','2026-02-03 19:04:57'),(2,'sara',NULL,NULL,NULL,1,'2026-02-04 10:00:18','2026-02-04 10:00:18');
/*!40000 ALTER TABLE `sales_people` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sessions` (
  `id` varchar(255) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `payload` longtext NOT NULL,
  `last_activity` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sessions`
--

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
INSERT INTO `sessions` VALUES ('84Hf2LmOwLsOCpWcLpxSVNDHCbYvk3uM7QpYIRgB',1,'100.66.108.92','Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Safari/537.36','YTo1OntzOjY6Il90b2tlbiI7czo0MDoibGxESjBsZFdJelhDWmNzMVZFOGlUVGFhbHZsVlRaSUR6ZUxzUER4ciI7czozOiJ1cmwiO2E6MDp7fXM6OToiX3ByZXZpb3VzIjthOjI6e3M6MzoidXJsIjtzOjQ1OiJodHRwOi8vMTAwLjExNi4yNDQuOTYvY29kZS9wdWJsaWMvY3VzdG9tZXJzLzIiO3M6NToicm91dGUiO3M6MTQ6ImN1c3RvbWVycy5zaG93Ijt9czo2OiJfZmxhc2giO2E6Mjp7czozOiJvbGQiO2E6MDp7fXM6MzoibmV3IjthOjA6e319czo1MDoibG9naW5fd2ViXzU5YmEzNmFkZGMyYjJmOTQwMTU4MGYwMTRjN2Y1OGVhNGUzMDk4OWQiO2k6MTt9',1770396483),('9KBsS3sxY5GPwV7yL3NDEd4NABZbkpvbm5Q9pDKi',NULL,NULL,'','YTozOntzOjY6Il90b2tlbiI7czo0MDoiR1FxR1NyWkg4Ym5QVEFKSjNNdkJIcHhsRFdnYjdTQXd4am13aW54bSI7czo5OiJfcHJldmlvdXMiO2E6Mjp7czozOiJ1cmwiO3M6ODoiaHR0cDovLzoiO3M6NToicm91dGUiO047fXM6NjoiX2ZsYXNoIjthOjI6e3M6Mzoib2xkIjthOjA6e31zOjM6Im5ldyI7YTowOnt9fX0=',1770398946),('9KH1QFsCVCiXxZVpaUKSRsmVj2YRHd5IBrPnIVhC',NULL,NULL,'','YTozOntzOjY6Il90b2tlbiI7czo0MDoiM1pBTEFTSDVDbzBJWEYwTE1PYTJucmxkUXE5djZsZTJvTTE2U0MxMSI7czo5OiJfcHJldmlvdXMiO2E6Mjp7czozOiJ1cmwiO3M6ODoiaHR0cDovLzoiO3M6NToicm91dGUiO047fXM6NjoiX2ZsYXNoIjthOjI6e3M6Mzoib2xkIjthOjA6e31zOjM6Im5ldyI7YTowOnt9fX0=',1770399085),('aewpAVxj7DFWfHzvirmwZHFiAvnG3rVrBzYkhjgb',NULL,NULL,'','YTozOntzOjY6Il90b2tlbiI7czo0MDoiU29FVWJ0Q3Q4QTJCUzEwbFdaTWtDT2JkNUk1dThLVmdORUdmeXh3RSI7czo5OiJfcHJldmlvdXMiO2E6Mjp7czozOiJ1cmwiO3M6ODoiaHR0cDovLzoiO3M6NToicm91dGUiO047fXM6NjoiX2ZsYXNoIjthOjI6e3M6Mzoib2xkIjthOjA6e31zOjM6Im5ldyI7YTowOnt9fX0=',1770399060),('asiywgycT569qU8MluO8WS20oh3LVAYuJNxStClg',NULL,NULL,'','YTozOntzOjY6Il90b2tlbiI7czo0MDoiUTBmMWxTRklhWU40TnU5NVpsRTl1TTJSNEFYWndSN0tURHBtTVNiVCI7czo5OiJfcHJldmlvdXMiO2E6Mjp7czozOiJ1cmwiO3M6ODoiaHR0cDovLzoiO3M6NToicm91dGUiO047fXM6NjoiX2ZsYXNoIjthOjI6e3M6Mzoib2xkIjthOjA6e31zOjM6Im5ldyI7YTowOnt9fX0=',1770399001),('cSWOTkWF38g9iT2F4ghJ31HT9ngSyr8p7h4f2gwA',1,'::1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Safari/537.36','YTo0OntzOjY6Il90b2tlbiI7czo0MDoiTEZIQlFnM3BJTlBIRmFVaVVrUmlqcnlHNTUwTGw0Nmx4dzZ4M2NvdiI7czo5OiJfcHJldmlvdXMiO2E6Mjp7czozOiJ1cmwiO3M6NDQ6Imh0dHA6Ly9sb2NhbGhvc3QvY29kZS9wdWJsaWMvc2V0dGluZ3MvYmFja3VwIjtzOjU6InJvdXRlIjtzOjIxOiJzZXR0aW5ncy5iYWNrdXAuaW5kZXgiO31zOjY6Il9mbGFzaCI7YToyOntzOjM6Im9sZCI7YTowOnt9czozOiJuZXciO2E6MDp7fX1zOjUwOiJsb2dpbl93ZWJfNTliYTM2YWRkYzJiMmY5NDAxNTgwZjAxNGM3ZjU4ZWE0ZTMwOTg5ZCI7aToxO30=',1770400180),('Eekzz51EKTh8mSIn4oQf7YnFhbiY0VO1STw2woXJ',NULL,NULL,'','YTozOntzOjY6Il90b2tlbiI7czo0MDoienpzMkVVZDhlUDJwQ1B6S201MGVQemNYT0lkT3BweGQ0VU5NQmxiMiI7czo5OiJfcHJldmlvdXMiO2E6Mjp7czozOiJ1cmwiO3M6ODoiaHR0cDovLzoiO3M6NToicm91dGUiO047fXM6NjoiX2ZsYXNoIjthOjI6e3M6Mzoib2xkIjthOjA6e31zOjM6Im5ldyI7YTowOnt9fX0=',1770398153),('H1irwpN1lvbALbbyLj2lx0YgUBXTs7K1lBVjXJDc',NULL,NULL,'','YTozOntzOjY6Il90b2tlbiI7czo0MDoiR0d0TlFPbFJKNGpscmo0d2E3eDlnZ3ZrZHpES21raG1rOHNBbmk5NyI7czo5OiJfcHJldmlvdXMiO2E6Mjp7czozOiJ1cmwiO3M6ODoiaHR0cDovLzoiO3M6NToicm91dGUiO047fXM6NjoiX2ZsYXNoIjthOjI6e3M6Mzoib2xkIjthOjA6e31zOjM6Im5ldyI7YTowOnt9fX0=',1770398079),('hrpruzrrxC29tSz40GKtoV4i2s0IVjFY4Wy8HSs2',NULL,NULL,'','YTozOntzOjY6Il90b2tlbiI7czo0MDoib1owVTRkMjJUT09PQXpFV3M0TFFWYTVGVVUwWTdvZHpJb0JHRDhXRSI7czo5OiJfcHJldmlvdXMiO2E6Mjp7czozOiJ1cmwiO3M6ODoiaHR0cDovLzoiO3M6NToicm91dGUiO047fXM6NjoiX2ZsYXNoIjthOjI6e3M6Mzoib2xkIjthOjA6e31zOjM6Im5ldyI7YTowOnt9fX0=',1770399125),('OC8Ibo2GpMRjJUW5yMe25OUWB1TSt8EkzDVBfuji',NULL,NULL,'','YTozOntzOjY6Il90b2tlbiI7czo0MDoiV3NNbjZGd0czbHIxcXU2d1VJUTlWY3VUMXE4ckxxbUtmeHpkZURtNSI7czo5OiJfcHJldmlvdXMiO2E6Mjp7czozOiJ1cmwiO3M6ODoiaHR0cDovLzoiO3M6NToicm91dGUiO047fXM6NjoiX2ZsYXNoIjthOjI6e3M6Mzoib2xkIjthOjA6e31zOjM6Im5ldyI7YTowOnt9fX0=',1770398117),('p1e5pNyrkLCyMUiq7r2Z4lHsZyc6QgF8GjwBEBiw',NULL,NULL,'','YTozOntzOjY6Il90b2tlbiI7czo0MDoiVmJPQUhUbXl6Rm1WVDZLYWg3WXF2anJ2SlY4Tkx4THVYMGpqaERJQyI7czo5OiJfcHJldmlvdXMiO2E6Mjp7czozOiJ1cmwiO3M6ODoiaHR0cDovLzoiO3M6NToicm91dGUiO047fXM6NjoiX2ZsYXNoIjthOjI6e3M6Mzoib2xkIjthOjA6e31zOjM6Im5ldyI7YTowOnt9fX0=',1770399172),('rNwKlk61wtyn9snfvcozs3bovevM7cEEkCfVSZml',NULL,NULL,'','YTozOntzOjY6Il90b2tlbiI7czo0MDoicjdVMXpwMzBBaXc5QmRGWTdsN3p5NElieEVxNmszUjljYjBVa1ByNyI7czo5OiJfcHJldmlvdXMiO2E6Mjp7czozOiJ1cmwiO3M6ODoiaHR0cDovLzoiO3M6NToicm91dGUiO047fXM6NjoiX2ZsYXNoIjthOjI6e3M6Mzoib2xkIjthOjA6e31zOjM6Im5ldyI7YTowOnt9fX0=',1770398493),('T3jKAgObOhtzeC5T9BOEzLgbCgoV42UjV8IGWeVr',NULL,NULL,'','YTozOntzOjY6Il90b2tlbiI7czo0MDoiWXZJN2NGc0VOVmRuTW5aTzZaekNDRmtnSnVwdk0za0J1OGhjY0RaUSI7czo5OiJfcHJldmlvdXMiO2E6Mjp7czozOiJ1cmwiO3M6ODoiaHR0cDovLzoiO3M6NToicm91dGUiO047fXM6NjoiX2ZsYXNoIjthOjI6e3M6Mzoib2xkIjthOjA6e31zOjM6Im5ldyI7YTowOnt9fX0=',1770399961),('uScjv8YkmuBcI4fyQqwDgS5PKZo1Ez1FGbrp11kG',NULL,NULL,'','YTozOntzOjY6Il90b2tlbiI7czo0MDoibmZGYzZrT1V3RzBqZUpDTWF4Skd1TE40eXNwdFF2STF0MVFod3FUMSI7czo5OiJfcHJldmlvdXMiO2E6Mjp7czozOiJ1cmwiO3M6ODoiaHR0cDovLzoiO3M6NToicm91dGUiO047fXM6NjoiX2ZsYXNoIjthOjI6e3M6Mzoib2xkIjthOjA6e31zOjM6Im5ldyI7YTowOnt9fX0=',1770398190),('VwCc3tq0OpRBChQBKgTpU9kS2smyWLusX5BaufKB',1,'100.66.108.92','Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Safari/537.36','YTo0OntzOjY6Il90b2tlbiI7czo0MDoiWlRuNHBWcDVQMnhCeUh3ZzVUMDltNjhPMXJjU3F4N3B3Q3RaSFRrQyI7czo5OiJfcHJldmlvdXMiO2E6Mjp7czozOiJ1cmwiO3M6NTU6Imh0dHA6Ly8xMDAuMTE2LjI0NC45Ni9jb2RlL3B1YmxpYy9hY2NvdW50aW5nL2N1cnJlbmNpZXMiO3M6NToicm91dGUiO3M6Mjc6ImFjY291bnRpbmcuY3VycmVuY2llcy5pbmRleCI7fXM6NjoiX2ZsYXNoIjthOjI6e3M6Mzoib2xkIjthOjA6e31zOjM6Im5ldyI7YTowOnt9fXM6NTA6ImxvZ2luX3dlYl81OWJhMzZhZGRjMmIyZjk0MDE1ODBmMDE0YzdmNThlYTRlMzA5ODlkIjtpOjE7fQ==',1770396081),('VxCXkGnuT0gRHwgmFb7gD3xc7xRAQLoZO820usrG',NULL,NULL,'','YTozOntzOjY6Il90b2tlbiI7czo0MDoiQ3hHNGhJcURWeE13Vm1OTTF0eWNwaXQwWW85d2V6NUNraU1oV1EzNyI7czo5OiJfcHJldmlvdXMiO2E6Mjp7czozOiJ1cmwiO3M6ODoiaHR0cDovLzoiO3M6NToicm91dGUiO047fXM6NjoiX2ZsYXNoIjthOjI6e3M6Mzoib2xkIjthOjA6e31zOjM6Im5ldyI7YTowOnt9fX0=',1770400175),('wurfLyYXS3vJDJATX7ujnZH8zBQVKXl03xGM91cU',NULL,NULL,'','YTozOntzOjY6Il90b2tlbiI7czo0MDoiemM3eVBMYVNnb0tHSkxIWDhwaHBQbWxiTHVGYnk5NlZYTGNYdXhFSyI7czo5OiJfcHJldmlvdXMiO2E6Mjp7czozOiJ1cmwiO3M6ODoiaHR0cDovLzoiO3M6NToicm91dGUiO047fXM6NjoiX2ZsYXNoIjthOjI6e3M6Mzoib2xkIjthOjA6e31zOjM6Im5ldyI7YTowOnt9fX0=',1770398113);
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `group` varchar(100) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `settings_group_key_unique` (`group`,`key`),
  KEY `settings_group_index` (`group`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (1,'general','company_name','SmartOneGroup ERP','2026-02-02 13:03:14','2026-02-02 13:03:14'),(2,'general','company_email','info@sog.eg','2026-02-02 13:03:14','2026-02-06 15:13:56'),(3,'general','company_phone','01112280212','2026-02-02 13:03:14','2026-02-06 15:13:56'),(4,'general','company_website','https://www.sog.eg','2026-02-02 13:03:14','2026-02-06 15:13:56'),(5,'general','company_address','Abdelsalam Elshazly st , Damanhour , Elbehira , Egypt','2026-02-02 13:03:14','2026-02-06 15:13:56'),(6,'general','timezone','UTC','2026-02-02 13:03:14','2026-02-02 13:03:14'),(7,'general','default_language','ar','2026-02-02 13:03:14','2026-02-03 19:43:22'),(8,'general','company_logo','uploads/settings/Sj8ODRm91r3eE0B2FZPX2bfL4qPUoGKp8B9HKa1O.png','2026-02-02 13:03:14','2026-02-02 13:03:14'),(9,'general','accounting_lock_date',NULL,'2026-02-02 13:03:14','2026-02-02 13:03:14'),(10,'general','expected_annual_revenue','1000000','2026-02-02 13:03:14','2026-02-02 13:03:14'),(11,'modules','module_crm','1','2026-02-02 18:37:01','2026-02-04 17:51:29'),(12,'modules','module_accounting','1','2026-02-02 18:37:01','2026-02-03 17:14:00'),(13,'modules','module_hr','1','2026-02-02 18:37:01','2026-02-03 18:18:28'),(14,'modules','module_inventory','1','2026-02-02 18:37:01','2026-02-03 18:18:28'),(15,'modules','module_projects','1','2026-02-02 18:37:01','2026-02-03 17:14:00'),(16,'modules','module_quotations','1','2026-02-02 18:37:01','2026-02-03 17:14:00'),(17,'modules','module_subscriptions','1','2026-02-02 18:37:01','2026-02-03 17:14:00'),(18,'modules','module_ai','1','2026-02-02 18:37:01','2026-02-03 17:14:00'),(19,'security','enable_otp','0','2026-02-03 19:40:06','2026-02-06 15:13:56'),(20,'whmcs','api_url','https://service.sog.eg/','2026-02-04 10:12:32','2026-02-04 18:53:01'),(21,'whmcs','api_identifier','ZwXxMNPu1CY1SbtDqCb6e5mnuHlrZLQT','2026-02-04 10:12:32','2026-02-04 10:12:32'),(22,'whmcs','api_secret','OadS5Ps12JFPfWArjSvZ2xv8DliYmR0A','2026-02-04 10:12:32','2026-02-04 10:12:32'),(23,'smtp','host','smtp.gmail.com','2026-02-04 17:52:18','2026-02-04 17:52:18'),(24,'smtp','port','587','2026-02-04 17:52:18','2026-02-04 17:52:18'),(25,'smtp','username','info@sog.eg','2026-02-04 17:52:18','2026-02-04 17:52:18'),(26,'smtp','password','Malek@007','2026-02-04 17:52:18','2026-02-04 17:52:18'),(27,'smtp','encryption','ssl','2026-02-04 17:52:18','2026-02-04 17:52:18'),(28,'smtp','from_address','info@sog.eg','2026-02-04 17:52:18','2026-02-04 17:52:18'),(29,'whmcs','last_sync_at','2026-02-05 13:00:50','2026-02-04 18:35:55','2026-02-05 11:00:50');
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_transactions`
--

DROP TABLE IF EXISTS `share_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `share_transactions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `investor_id` bigint(20) unsigned NOT NULL,
  `type` enum('buy','sell') NOT NULL,
  `shares` int(11) NOT NULL,
  `price_per_share` decimal(15,2) NOT NULL,
  `total_amount` decimal(15,2) NOT NULL,
  `date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `share_transactions_investor_id_foreign` (`investor_id`),
  CONSTRAINT `share_transactions_investor_id_foreign` FOREIGN KEY (`investor_id`) REFERENCES `investors` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_transactions`
--

LOCK TABLES `share_transactions` WRITE;
/*!40000 ALTER TABLE `share_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `software_licenses`
--

DROP TABLE IF EXISTS `software_licenses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `software_licenses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint(20) unsigned NOT NULL,
  `software_name` varchar(255) NOT NULL,
  `serial_key` varchar(255) NOT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `status` varchar(255) NOT NULL DEFAULT 'active',
  `whmcs_id` int(11) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `software_licenses_customer_id_foreign` (`customer_id`),
  CONSTRAINT `software_licenses_customer_id_foreign` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `software_licenses`
--

LOCK TABLES `software_licenses` WRITE;
/*!40000 ALTER TABLE `software_licenses` DISABLE KEYS */;
/*!40000 ALTER TABLE `software_licenses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `subscriptions`
--

DROP TABLE IF EXISTS `subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `subscriptions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint(20) unsigned NOT NULL,
  `service_name` varchar(255) NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `currency` varchar(3) NOT NULL DEFAULT 'EGP',
  `billing_cycle` varchar(255) NOT NULL DEFAULT 'Monthly',
  `start_date` date DEFAULT NULL,
  `next_due_date` date DEFAULT NULL,
  `status` varchar(255) NOT NULL DEFAULT 'active',
  `whmcs_service_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `subscriptions_customer_id_foreign` (`customer_id`),
  KEY `subscriptions_whmcs_service_id_index` (`whmcs_service_id`),
  CONSTRAINT `subscriptions_customer_id_foreign` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `subscriptions`
--

LOCK TABLES `subscriptions` WRITE;
/*!40000 ALTER TABLE `subscriptions` DISABLE KEYS */;
/*!40000 ALTER TABLE `subscriptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `supplier_services`
--

DROP TABLE IF EXISTS `supplier_services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `supplier_services` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `supplier_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `type` enum('reseller','server','domain','other') NOT NULL DEFAULT 'other',
  `cost_price` decimal(15,2) NOT NULL,
  `currency_id` bigint(20) unsigned NOT NULL,
  `reseller_units` int(11) DEFAULT NULL,
  `markup_type` enum('fixed','percentage') NOT NULL DEFAULT 'fixed',
  `markup_value` decimal(15,2) NOT NULL DEFAULT 0.00,
  `notes` text DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_services_supplier_id_foreign` (`supplier_id`),
  KEY `supplier_services_currency_id_foreign` (`currency_id`),
  CONSTRAINT `supplier_services_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`),
  CONSTRAINT `supplier_services_supplier_id_foreign` FOREIGN KEY (`supplier_id`) REFERENCES `suppliers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `supplier_services`
--

LOCK TABLES `supplier_services` WRITE;
/*!40000 ALTER TABLE `supplier_services` DISABLE KEYS */;
/*!40000 ALTER TABLE `supplier_services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers`
--

DROP TABLE IF EXISTS `suppliers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `suppliers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `whatsapp` varchar(255) DEFAULT NULL,
  `tax_id` varchar(255) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `currency_id` bigint(20) unsigned DEFAULT NULL,
  `opening_balance` decimal(15,2) NOT NULL DEFAULT 0.00,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `suppliers_currency_id_foreign` (`currency_id`),
  CONSTRAINT `suppliers_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers`
--

LOCK TABLES `suppliers` WRITE;
/*!40000 ALTER TABLE `suppliers` DISABLE KEYS */;
INSERT INTO `suppliers` VALUES (1,'Namesilo',NULL,NULL,NULL,NULL,'USA',NULL,1,2,0.00,'2026-02-04 17:42:28','2026-02-05 11:35:42'),(2,'NameCheap',NULL,NULL,NULL,NULL,NULL,NULL,1,2,0.00,'2026-02-04 17:42:40','2026-02-05 11:35:36'),(3,'HHOST',NULL,NULL,NULL,NULL,NULL,NULL,1,2,0.00,'2026-02-04 17:42:48','2026-02-05 11:35:28');
/*!40000 ALTER TABLE `suppliers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ticket_messages`
--

DROP TABLE IF EXISTS `ticket_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ticket_messages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ticket_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `message` text NOT NULL,
  `is_admin` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ticket_messages_ticket_id_foreign` (`ticket_id`),
  KEY `ticket_messages_user_id_foreign` (`user_id`),
  KEY `ticket_messages_customer_id_foreign` (`customer_id`),
  CONSTRAINT `ticket_messages_customer_id_foreign` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`id`) ON DELETE SET NULL,
  CONSTRAINT `ticket_messages_ticket_id_foreign` FOREIGN KEY (`ticket_id`) REFERENCES `tickets` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ticket_messages_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ticket_messages`
--

LOCK TABLES `ticket_messages` WRITE;
/*!40000 ALTER TABLE `ticket_messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `ticket_messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tickets`
--

DROP TABLE IF EXISTS `tickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tickets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint(20) unsigned NOT NULL,
  `whmcs_id` int(11) DEFAULT NULL,
  `subject` varchar(255) NOT NULL,
  `status` varchar(255) NOT NULL DEFAULT 'Open',
  `priority` varchar(255) NOT NULL DEFAULT 'Medium',
  `department` varchar(255) DEFAULT NULL,
  `last_reply` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tickets_customer_id_foreign` (`customer_id`),
  KEY `tickets_whmcs_id_index` (`whmcs_id`),
  CONSTRAINT `tickets_customer_id_foreign` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tickets`
--

LOCK TABLES `tickets` WRITE;
/*!40000 ALTER TABLE `tickets` DISABLE KEYS */;
/*!40000 ALTER TABLE `tickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `units`
--

DROP TABLE IF EXISTS `units`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `units` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `short_name` varchar(255) DEFAULT NULL,
  `type` enum('quantity','time') NOT NULL DEFAULT 'quantity',
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `parent_id` bigint(20) unsigned DEFAULT NULL,
  `conversion_factor` decimal(10,4) NOT NULL DEFAULT 1.0000,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `units_name_unique` (`name`),
  KEY `units_parent_id_foreign` (`parent_id`),
  CONSTRAINT `units_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `units` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `units`
--

LOCK TABLES `units` WRITE;
/*!40000 ALTER TABLE `units` DISABLE KEYS */;
INSERT INTO `units` VALUES (1,'Piece','pc','quantity',1,NULL,1.0000,'2026-02-04 11:21:55','2026-02-04 11:21:55'),(2,'Service','svc','quantity',1,NULL,1.0000,'2026-02-04 11:21:55','2026-02-04 11:21:55'),(4,'Gram','g','quantity',1,NULL,0.0010,'2026-02-04 11:21:55','2026-02-04 11:21:55'),(5,'Monthly','mo','time',1,NULL,1.0000,'2026-02-04 11:21:55','2026-02-04 11:21:55'),(6,'Quarterly','qtr','time',1,NULL,1.0000,'2026-02-04 11:21:55','2026-02-04 11:21:55'),(7,'Semi-Annually','hy','time',1,NULL,1.0000,'2026-02-04 11:21:55','2026-02-04 11:21:55'),(8,'Annually','yr','time',1,NULL,1.0000,'2026-02-04 11:21:55','2026-02-04 11:21:55'),(9,'One Time','once','quantity',1,NULL,1.0000,'2026-02-04 11:21:55','2026-02-04 11:21:55');
/*!40000 ALTER TABLE `units` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `otp_code` varchar(6) DEFAULT NULL,
  `otp_expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_phone_unique` (`phone`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'Mahmoud Mansour','mahmoud@sog.eg','01119060707','2026-02-01 15:19:33','$2y$12$PK88VdkWeXEwuX24MqLLH.ElHwotcUKvDZE05PdtXDhOPsfRe92y.','jGiwQ8avKE2Rta9xYMsA5STV44dNWqjVyd0sZvzkjYxj0vTEAg0BT8AOOK9E',NULL,NULL,'2026-02-01 15:19:33','2026-02-03 15:40:20'),(3,'Maged elhabrouk','Melhabrouk10@gmail.com','01018726698',NULL,'$2y$12$LHrWyy9xeZt.NSHULqTGTuUk9yNE22rFeIR23DtldAulMi4P385Qy',NULL,NULL,NULL,'2026-02-04 16:03:28','2026-02-04 16:03:28'),(4,'Sara Rashed','sararashed6796@gmail.com','01060651355',NULL,'$2y$12$d91xJuS2bL3fHFu6GKGC2.oTfGxMzZYHGkkXD/6lPM5Q8v795s0qG',NULL,NULL,NULL,'2026-02-05 11:56:21','2026-02-05 11:56:21');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `warehouses`
--

DROP TABLE IF EXISTS `warehouses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `warehouses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `address` text DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `manager_name` varchar(255) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `description` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `warehouses`
--

LOCK TABLES `warehouses` WRITE;
/*!40000 ALTER TABLE `warehouses` DISABLE KEYS */;
/*!40000 ALTER TABLE `warehouses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whmcs_imports`
--

DROP TABLE IF EXISTS `whmcs_imports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `whmcs_imports` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(50) NOT NULL,
  `whmcs_id` bigint(20) unsigned NOT NULL,
  `title` text DEFAULT NULL,
  `data` longtext NOT NULL,
  `status` enum('pending','imported','rejected') NOT NULL DEFAULT 'pending',
  `error_log` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `whmcs_imports_type_whmcs_id_status_unique` (`type`,`whmcs_id`,`status`),
  KEY `whmcs_imports_type_index` (`type`),
  KEY `whmcs_imports_whmcs_id_index` (`whmcs_id`),
  KEY `whmcs_imports_status_index` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whmcs_imports`
--

LOCK TABLES `whmcs_imports` WRITE;
/*!40000 ALTER TABLE `whmcs_imports` DISABLE KEYS */;
/*!40000 ALTER TABLE `whmcs_imports` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2026-02-06 19:49:43
