# SmartOne Portal - Android App Setup

This project is configured as a **Progressive Web App (PWA)**, allowing it to be installed on Android devices and behave like a native application.

## How to Install on Android

1.  Open the **Chrome** browser on your Android device.
2.  Navigate to the portal URL (e.g., `https://your-domain.com/portal`).
3.  Tap the **three-dot menu** ⋮ in the top right corner.
4.  Select **"Add to Home screen"** or **"Install App"**.
5.  Follow the prompts to add the app icon to your home screen.

Once installed:
-   The app will launch in full-screen mode (no browser bar).
-   It will appear in your app drawer like any other app.
-   It will cache basic pages for offline reliability (thanks to the Service Worker).

## How to Create a Real APK (Optional)

**Important:** To generate an APK using online tools, your website must be **hosted on a live server** (e.g., `https://your-domain.com`). It will *not* work with `localhost` or `127.0.0.1`.

If you have a live URL:

1.  Visit [PWABuilder.com](https://www.pwabuilder.com).
2.  Enter the full URL of your live portal (e.g., `https://smartone-portal.com`).
3.  Click **Start**.
4.  Wait for the audit to complete (you should see a high checkmark score for "Manifest").
5.  Click the **Build Package For Stores** button.
6.  Select **Android**.
7.  Download the package.
8.  Inside the downloaded `.zip` file, look for the `.apk` file (often in `android/app/build/outputs/apk/debug`).
9.  Copy this `.apk` file to your phone and install it.

**Note:** Since we don't have the Android SDK installed on this computer, this online method is the easiest way to get an APK file.
