<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class CleanSystemData extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:clean-data';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Clean all experimental data (customers, transactions, quotations, invoices)';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        if (!$this->confirm('This will DELETE all business data (customers, invoices, transactions, etc.). Are you sure?')) {
            return;
        }

        $this->info('Cleaning system data...');

        DB::statement('SET FOREIGN_KEY_CHECKS=0;');

        $tables = [
            'invoices',
            'invoice_items',
            'quotations',
            'quotation_items',
            'projects',
            'programmer_payments',
            'financial_transactions',
            'financial_treasuries',
            'customers',
            'suppliers', // Assuming suppliers might exist
            'products', // Maybe? User said "customers and movements"
        ];

        foreach ($tables as $table) {
            if (Schema::hasTable($table)) {
                DB::table($table)->truncate();
                $this->line("Truncated: $table");
            }
        }

        DB::statement('SET FOREIGN_KEY_CHECKS=1;');

        $this->info('System data cleaned successfully.');
    }
}
