<?php

namespace App\Http\Controllers\Accounting;

use App\Http\Controllers\Controller;
use App\Models\SoftwareLicense;
use App\Models\Customer;
use App\Services\WhmcsService;
use App\Services\WaSenderService;
use Illuminate\Http\Request;

class LicenseController extends Controller
{
    protected $whmcs;
    protected $waSender;

    public function __construct(WhmcsService $whmcs, WaSenderService $waSender)
    {
        $this->whmcs = $whmcs;
        $this->waSender = $waSender;
    }

    public function sync(Customer $customer)
    {
        if (!$customer->whmcs_id) {
            return back()->with('error', 'Customer not linked to WHMCS.');
        }

        $result = $this->whmcs->syncAllLicenses();

        if ($result['success']) {
            return back()->with('success', "Successfully synced licenses from WHMCS.");
        } else {
            return back()->with('error', "Failed to sync: " . $result['message']);
        }
    }

    public function sendWhatsapp(Request $request, Customer $customer)
    {
        $validated = $request->validate([
            'serial_key' => 'required|string',
            'software_name' => 'required|string',
        ]);

        $phone = $customer->whatsapp ?: $customer->phone;

        if (!$phone) {
            return response()->json(['success' => false, 'message' => 'Customer has no phone number.']);
        }

        $result = $this->waSender->sendWhatsAppTemplate($phone, 'client_license_info', [
            'customer_name' => $customer->name,
            'software_name' => $validated['software_name'],
            'serial_key' => $validated['serial_key']
        ]);

        if ($result['success']) {
            return response()->json(['success' => true, 'message' => 'Serial sent successfully via WhatsApp.']);
        } else {
            return response()->json(['success' => false, 'message' => 'Failed to send WhatsApp: ' . $result['message']]);
        }
    }
}
