<?php

namespace App\Http\Controllers;

use App\Models\Customer;
use App\Models\Setting;
use App\Services\WhmcsService;
use App\Models\Invoice;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index(\App\Services\AIService $aiService)
    {
        $stats = [
            'total_customers' => Customer::count(),
            'active_customers' => Customer::active()->count(),
            'whmcs_customers' => Customer::fromWhmcs()->count(),
            'recent_customers' => Customer::latest()->take(5)->get(),
            'total_commissions' => \App\Models\SalesCommission::sum('amount'),
            'pending_commissions' => \App\Models\SalesPerson::all()->sum('balance'),
            'sales_staff_count' => \App\Models\SalesPerson::active()->count(),
            'total_revenue' => Invoice::where('status', 'paid')->sum('total'),
            'active_projects' => \App\Models\Project::where('status', '!=', 'completed')->count(),
            'avg_project_completion' => \App\Models\Project::where('status', '!=', 'completed')->avg('progress_percent') ?? 0,
        ];

        // Monthly Revenue Data (Last 6 Months)
        $months = [];
        $revenueData = [];
        for ($i = 5; $i >= 0; $i--) {
            $date = \Carbon\Carbon::now()->subMonths($i);
            $months[] = $date->format('M Y');
            $revenueData[] = Invoice::where('status', 'paid')
                ->whereYear('created_at', $date->year)
                ->whereMonth('created_at', $date->month)
                ->sum('total');
        }

        // Invoice Status Distribution
        $invoiceStats = [
            'paid' => Invoice::where('status', 'paid')->count(),
            'unpaid' => Invoice::where('status', 'unpaid')->count(),
            'partial' => Invoice::where('status', 'partial')->count(),
        ];

        // Check integrations status
        $integrations = [
            'whmcs' => !empty(Setting::getValue('whmcs', 'api_url')),
            'wasender' => !empty(Setting::getValue('wasender', 'api_key')),
            'smtp' => !empty(Setting::getValue('smtp', 'host')),
        ];

        // AI Insights (only if enabled)
        $aiInsights = [];
        if (Setting::isModuleEnabled('module_ai')) {
            $aiInsights = $aiService->getInsights();
        }

        return view('dashboard.index', compact('stats', 'integrations', 'aiInsights', 'months', 'revenueData', 'invoiceStats'));
    }
}
