<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Customer;
use App\Models\Project;
use App\Models\Invoice; // Assuming you have an Invoice model
use Illuminate\Support\Str;

class SearchController extends Controller
{
    public function search(Request $request)
    {
        $query = $request->input('query');
        $type = $request->input('type', 'all');

        if (strlen($query) < 2) {
            return response()->json([]);
        }

        $results = [];

        // Search Customers
        if ($type === 'all' || $type === 'customers') {
            $customers = Customer::where('name', 'like', "%{$query}%")
                ->orWhere('email', 'like', "%{$query}%")
                ->orWhere('phone', 'like', "%{$query}%")
                ->orWhere('company', 'like', "%{$query}%")
                ->orWhere('customer_number', 'like', "%{$query}%")
                ->take(5)
                ->get();

            foreach ($customers as $customer) {
                $results[] = [
                    'title' => $customer->name,
                    'subtitle' => $customer->company ?? $customer->email,
                    'type' => 'customer',
                    'icon' => 'fas fa-user-tie',
                    'url' => route('customers.show', $customer->id),
                    'color' => 'success'
                ];
            }
        }

        // Search Users
        if ($type === 'all' || $type === 'users') {
            $users = User::where('name', 'like', "%{$query}%")
                ->orWhere('email', 'like', "%{$query}%")
                ->orWhere('phone', 'like', "%{$query}%")
                ->take(5)
                ->get();

            foreach ($users as $user) {
                $results[] = [
                    'title' => $user->name,
                    'subtitle' => $user->email,
                    'type' => 'user',
                    'icon' => 'fas fa-user-shield',
                    'url' => route('settings.users.edit', $user->id),
                    'color' => 'primary'
                ];
            }
        }

        // Search Invoices
        if (($type === 'all' || $type === 'invoices') && class_exists(Invoice::class)) {
            $invoices = Invoice::where('invoice_number', 'like', "%{$query}%")
                ->take(5)
                ->get();

            foreach ($invoices as $invoice) {
                $results[] = [
                    'title' => __('Invoice') . ' #' . $invoice->invoice_number,
                    'subtitle' => $invoice->client->name ?? '',
                    'type' => 'invoice',
                    'icon' => 'fas fa-file-invoice-dollar',
                    'url' => route('accounting.invoices.show', $invoice->id),
                    'color' => 'warning'
                ];
            }
        }

        // Search Projects
        if (($type === 'all' || $type === 'projects') && class_exists(Project::class)) {
            $projects = Project::where('name', 'like', "%{$query}%")
                ->take(5)
                ->get();

            foreach ($projects as $project) {
                $results[] = [
                    'title' => $project->name,
                    'subtitle' => Str::limit($project->description, 30),
                    'type' => 'project',
                    'icon' => 'fas fa-project-diagram',
                    'url' => route('projects.show', $project->id),
                    'color' => 'info'
                ];
            }
        }

        return response()->json($results);
    }
}
