<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use App\Models\Customer;

class PortalAuth
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // 1. Check if session has customer_id
        if (session()->has('portal_customer_id')) {
            return $next($request);
        }

        // 2. Check if route has 'token' parameter (Legacy/Direct Link support)
        if ($request->route('token')) {
            $token = $request->route('token');
            $customer = Customer::where('portal_token', $token)->first();

            if ($customer) {
                // Log them in via session for future requests
                session(['portal_customer_id' => $customer->id]);
                return $next($request);
            }
        }

        // 3. Not authenticated
        return redirect()->route('portal.login')->with('error', __('Please login to access the portal.'));
    }
}
