<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Bill extends Model
{
    use HasFactory;

    protected $fillable = [
        'supplier_id',
        'code',
        'date',
        'due_date',
        'subtotal',
        'tax_amount',
        'total',
        'paid_amount',
        'status',
        'notes',
        'currency_id',
        'exchange_rate',
    ];

    protected $casts = [
        'date' => 'date',
        'due_date' => 'date',
        'subtotal' => 'decimal:2',
        'tax_amount' => 'decimal:2',
        'total' => 'decimal:2',
        'paid_amount' => 'decimal:2',
        'exchange_rate' => 'decimal:6',
    ];

    public function supplier()
    {
        return $this->belongsTo(Supplier::class);
    }

    public function currency()
    {
        return $this->belongsTo(Currency::class);
    }

    public function transactions()
    {
        return $this->morphMany(FinancialTransaction::class, 'model');
    }

    public function items()
    {
        return $this->hasMany(BillItem::class);
    }
}
