<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Currency extends Model
{
    protected $fillable = [
        'code',
        'name',
        'symbol',
        'exchange_rate',
        'is_base',
        'is_active',
    ];

    protected $casts = [
        'is_base' => 'boolean',
        'is_active' => 'boolean',
        'exchange_rate' => 'decimal:6',
    ];

    public static function getBase()
    {
        return self::where('is_base', true)->first() ?? self::first();
    }
}
