<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Employee extends Model
{
    use HasFactory;

    protected $fillable = [
        'first_name',
        'last_name',
        'email',
        'phone',
        'position', // Keeping for backward compatibility if needed, or migration to Designation
        'department_id',
        'designation_id',
        'basic_salary',
        'hourly_rate',
        'salary', // salary kept for backward compatibility
        'hire_date',
        'joining_date',
        'status',
        'shift_type',
        'address',
        'emergency_contact',
        'notes',
        'is_active'
    ];

    protected $casts = [
        'basic_salary' => 'decimal:2',
        'hourly_rate' => 'decimal:2',
        'salary' => 'decimal:2',
        'hire_date' => 'date',
        'joining_date' => 'date',
        'is_active' => 'boolean',
    ];

    public function assignedDepartment()
    {
        return $this->belongsTo(Department::class, 'department_id');
    }

    public function assignedDesignation()
    {
        return $this->belongsTo(Designation::class, 'designation_id');
    }

    // Accessor for Full Name
    public function getNameAttribute()
    {
        return "{$this->first_name} {$this->last_name}";
    }

    public function getFullNameAttribute()
    {
        return "{$this->first_name} {$this->last_name}";
    }

    public function scopeActive($query)
    {
        return $query->where('status', 'active');
    }

    public function attendanceLogs()
    {
        return $this->hasMany(Attendance::class);
    }

    public function payrolls()
    {
        return $this->hasMany(Payroll::class);
    }
}
