<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class FinancialTreasury extends Model
{
    protected $fillable = [
        'name',
        'type',
        'currency',
        'currency_id',
        'balance',
        'is_active'
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'balance' => 'decimal:2',
    ];

    public function transactions(): HasMany
    {
        return $this->hasMany(FinancialTransaction::class, 'treasury_id');
    }

    public function currency()
    {
        return $this->belongsTo(\App\Models\Currency::class, 'currency_id');
    }

    // Alias for consistency if needed, but 'currency' is good.
    public function getCurrencyModel()
    {
        return $this->belongsTo(\App\Models\Currency::class, 'currency_id');
    }
}
