<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Investor extends Model
{
    protected $fillable = [
        'name',
        'email',
        'phone',
        'total_shares',
        'total_investment',
        'avg_purchase_price',
    ];

    public function shareTransactions(): HasMany
    {
        return $this->hasMany(ShareTransaction::class);
    }

    public function profitDistributions(): HasMany
    {
        return $this->hasMany(ProfitDistribution::class);
    }
}
