<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\MorphMany;

/**
 * @property \Illuminate\Support\Carbon $date
 * @property \Illuminate\Support\Carbon|null $due_date
 */
class Invoice extends Model
{
    protected $fillable = [
        'customer_id',
        'currency_id',
        'exchange_rate',
        'project_id',
        'code',
        'status',
        'date',
        'due_date',
        'subtotal',
        'tax_percent',
        'tax_amount',
        'discount_amount',
        'total',
        'paid_amount',
        'notes',
        'uuid',
        'sales_person_id',
        'commission_amount',
        'loyalty_points_redeemed',
        'loyalty_amount_redeemed',
        'discount_type',
        'discount_value',
        'shipping_amount',
        'extra_expenses_amount',
        'extra_expenses_note',
        'is_tax_invoice',
    ];

    protected $casts = [
        'date' => 'date',
        'due_date' => 'date',
        'subtotal' => 'decimal:2',
        'tax_percent' => 'decimal:2',
        'tax_amount' => 'decimal:2',
        'discount_amount' => 'decimal:2',
        'total' => 'decimal:2',
        'paid_amount' => 'decimal:2',
        'loyalty_points_redeemed' => 'decimal:2',
        'loyalty_amount_redeemed' => 'decimal:2',
        'is_tax_invoice' => 'boolean',
    ];

    public function customer(): BelongsTo
    {
        return $this->belongsTo(Customer::class);
    }

    public function project(): BelongsTo
    {
        return $this->belongsTo(Project::class);
    }

    public function items(): HasMany
    {
        return $this->hasMany(InvoiceItem::class);
    }

    public function transactions(): MorphMany
    {
        return $this->morphMany(FinancialTransaction::class, 'model');
    }

    public function salesPerson(): BelongsTo
    {
        return $this->belongsTo(SalesPerson::class);
    }
}
