<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Partner extends Model
{
    protected $fillable = [
        'name',
        'email',
        'phone',
        'ownership_percent',
        'capital_invested',
        'is_active',
    ];

    public function profitDistributions(): HasMany
    {
        return $this->hasMany(ProfitDistribution::class);
    }
}
