<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Unit; // Added this line

class Product extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'code', 'type', 'unit_id', 'sku', 'price', 'stock', 'min_stock', 'description', 'is_active'];

    public function unit()
    {
        return $this->belongsTo(Unit::class);
    }

    protected $casts = [
        'is_active' => 'boolean',
        'price' => 'decimal:2',
    ];
}
