<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphMany;

class SalesCommissionPayment extends Model
{
    protected $fillable = ['sales_person_id', 'amount', 'date', 'treasury_id', 'payment_method', 'notes', 'user_id'];

    protected $casts = [
        'date' => 'date',
    ];

    public function salesPerson(): BelongsTo
    {
        return $this->belongsTo(SalesPerson::class);
    }

    public function treasury(): BelongsTo
    {
        return $this->belongsTo(FinancialTreasury::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function transactions(): MorphMany
    {
        return $this->morphMany(FinancialTransaction::class, 'model');
    }
}
