<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class SalesPerson extends Model
{
    protected $fillable = ['name', 'phone', 'email', 'whatsapp', 'is_active'];

    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function commissions(): HasMany
    {
        return $this->hasMany(SalesCommission::class);
    }

    public function payments(): HasMany
    {
        return $this->hasMany(SalesCommissionPayment::class);
    }

    public function getBalanceAttribute()
    {
        $totalCommissions = $this->commissions()->sum('amount');
        $totalPayments = $this->payments()->sum('amount');
        return $totalCommissions - $totalPayments;
    }
}
