<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ShareTransaction extends Model
{
    protected $fillable = [
        'investor_id',
        'type',
        'shares',
        'price_per_share',
        'total_amount',
        'date',
    ];

    protected $casts = [
        'date' => 'date',
    ];

    public function investor(): BelongsTo
    {
        return $this->belongsTo(Investor::class);
    }
}
