<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Subscription extends Model
{
    use HasFactory;

    protected $fillable = [
        'customer_id',
        'service_name',
        'price',
        'currency',
        'billing_cycle',
        'start_date',
        'next_due_date',
        'status',
        'whmcs_service_id',
    ];

    protected $casts = [
        'start_date' => 'date',
        'next_due_date' => 'date',
        'price' => 'decimal:2',
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function scopeActive($query)
    {
        return $query->where('status', 'active');
    }
}
