<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Ticket extends Model
{
    protected $fillable = [
        'customer_id',
        'whmcs_id',
        'subject',
        'status',
        'priority',
        'department',
        'last_reply',
    ];

    protected $dates = ['last_reply'];

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function messages()
    {
        return $this->hasMany(TicketMessage::class);
    }
}
