<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Warehouse extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'address',
        'phone',
        'email',
        'manager_name',
        'is_active',
        'is_default',
        'description',
    ];

    /**
     * Initial Scope to filter active warehouses.
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }
}
