<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class WhatsAppTemplate extends Model
{
    protected $table = 'whatsapp_templates';

    protected $fillable = ['name', 'key', 'content', 'variables', 'is_active'];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    /**
     * Parse template with provided data
     */
    public function parse($data)
    {
        $content = $this->content;
        foreach ($data as $key => $value) {
            $content = str_replace('{' . $key . '}', $value, $content);
        }
        return $content;
    }
}
