<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('financial_transactions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('treasury_id')->constrained('financial_treasuries')->onDelete('restrict');
            $table->foreignId('category_id')->nullable()->constrained('financial_categories')->onDelete('set null');
            $table->foreignId('user_id')->constrained('users');
            $table->decimal('amount', 15, 2);
            $table->enum('type', ['in', 'out']); // Deposit or Withdrawal
            $table->date('date');
            $table->text('description')->nullable();
            $table->string('ref_no')->nullable(); // External Reference
            $table->nullableMorphs('model'); // Link to Invoice or Transfer
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('financial_transactions');
    }
};
