<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Partners (Owners)
        Schema::create('partners', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->decimal('ownership_percent', 5, 2); // e.g., 25.00
            $table->decimal('capital_invested', 15, 2)->default(0);
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });

        // Investors (Shareholders)
        Schema::create('investors', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->integer('total_shares')->default(0);
            $table->decimal('total_investment', 15, 2)->default(0);
            $table->decimal('avg_purchase_price', 15, 2)->default(0);
            $table->timestamps();
        });

        // Share Transactions (Buy/Sell)
        Schema::create('share_transactions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('investor_id')->constrained()->cascadeOnDelete();
            $table->enum('type', ['buy', 'sell']);
            $table->integer('shares');
            $table->decimal('price_per_share', 15, 2);
            $table->decimal('total_amount', 15, 2);
            $table->date('date');
            $table->timestamps();
        });

        // Profit & Dividend Distributions
        Schema::create('profit_distributions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('partner_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('investor_id')->nullable()->constrained()->nullOnDelete();
            $table->enum('type', ['partner', 'shareholder']);
            $table->decimal('amount', 15, 2);
            $table->date('date');
            $table->date('period_start');
            $table->date('period_end');
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('profit_distributions');
        Schema::dropIfExists('share_transactions');
        Schema::dropIfExists('investors');
        Schema::dropIfExists('partners');
    }
};
