<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('supplier_services', function (Blueprint $table) {
            $table->id();
            $table->foreignId('supplier_id')->constrained()->onDelete('cascade');
            $table->string('name');
            $table->enum('type', ['reseller', 'server', 'domain', 'other'])->default('other');

            // Cost details
            $table->decimal('cost_price', 15, 2);
            $table->foreignId('currency_id')->constrained('currencies');

            // Reseller specific
            $table->integer('reseller_units')->nullable(); // e.g. 60 sites

            // Markup logic
            $table->enum('markup_type', ['fixed', 'percentage'])->default('fixed');
            $table->decimal('markup_value', 15, 2)->default(0);

            $table->text('notes')->nullable();
            $table->boolean('is_active')->is_active(true);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('supplier_services');
    }
};
