<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('sales_commission_payments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('sales_person_id')->constrained()->onDelete('cascade');
            $table->decimal('amount', 15, 2);
            $table->date('date');
            $table->foreignId('treasury_id')->constrained('financial_treasuries')->onDelete('cascade');
            $table->string('payment_method')->default('cash');
            $table->text('notes')->nullable();
            $table->foreignId('user_id')->constrained()->onDelete('cascade'); // Who recorded the payment
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('sales_commission_payments');
    }
};
