<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('invoices', function (Blueprint $table) {
            $table->foreignId('sales_person_id')->nullable()->constrained('sales_people')->nullOnDelete();
            $table->decimal('commission_amount', 15, 2)->default(0);
        });
    }

    public function down(): void
    {
        Schema::table('invoices', function (Blueprint $table) {
            $table->dropForeign(['sales_person_id']);
            $table->dropColumn(['sales_person_id', 'commission_amount']);
        });
    }
};
