<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('subscriptions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('customer_id')->constrained()->onDelete('cascade');
            $table->string('service_name');
            $table->decimal('price', 10, 2);
            $table->string('currency', 3)->default('EGP'); // EGP or USD
            $table->string('billing_cycle')->default('Monthly'); // Monthly, Annually
            $table->date('start_date')->nullable();
            $table->date('next_due_date')->nullable();
            $table->string('status')->default('active'); // active, suspended, cancelled
            $table->integer('whmcs_service_id')->nullable()->index();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subscriptions');
    }
};
