<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('invoices', function (Blueprint $table) {
            if (!Schema::hasColumn('invoices', 'loyalty_points_redeemed')) {
                $table->decimal('loyalty_points_redeemed', 15, 2)->default(0);
            }
            if (!Schema::hasColumn('invoices', 'loyalty_amount_redeemed')) {
                $table->decimal('loyalty_amount_redeemed', 15, 2)->default(0);
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('invoices', function (Blueprint $table) {
            //
        });
    }
};
