<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('customers', function (Blueprint $table) {
            if (!Schema::hasColumn('customers', 'customer_group_id')) {
                $table->foreignId('customer_group_id')->nullable()->constrained('customer_groups')->nullOnDelete();
            }
            if (!Schema::hasColumn('customers', 'loyalty_enabled')) {
                $table->boolean('loyalty_enabled')->default(false);
            }
            if (!Schema::hasColumn('customers', 'loyalty_points')) {
                $table->decimal('loyalty_points', 15, 2)->default(0);
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('customers', function (Blueprint $table) {
            //
        });
    }
};
