<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('whmcs_imports', function (Blueprint $table) {
            $table->id();
            $table->string('type', 50)->index(); // 'client', 'invoice', 'service', 'domain', 'ticket'
            $table->unsignedBigInteger('whmcs_id')->index();
            $table->text('title')->nullable(); // Description/Name for easy reading
            $table->longText('data'); // Full JSON payload
            $table->enum('status', ['pending', 'imported', 'rejected'])->default('pending')->index();
            $table->text('error_log')->nullable();
            $table->timestamps();

            // composite unique key to prevent duplicates in pending queue
            $table->unique(['type', 'whmcs_id', 'status']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('whmcs_imports');
    }
};
