<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // 1. Create Departments Table
        if (!Schema::hasTable('departments')) {
            Schema::create('departments', function (Blueprint $table) {
                $table->id();
                $table->string('name');
                $table->boolean('is_active')->default(true);
                $table->unsignedBigInteger('manager_id')->nullable();
                $table->timestamps();
            });
        }

        // 2. Create Designations (Job Titles) Table
        if (!Schema::hasTable('designations')) {
            Schema::create('designations', function (Blueprint $table) {
                $table->id();
                $table->string('name');
                $table->integer('level')->default(1); // Hierarchy level
                $table->boolean('is_active')->default(true);
                $table->timestamps();
            });
        }

        // 3. Update Employees Table
        Schema::table('employees', function (Blueprint $table) {
            if (!Schema::hasColumn('employees', 'department_id')) {
                $table->foreignId('department_id')->nullable()->constrained('departments')->nullOnDelete();
            }
            if (!Schema::hasColumn('employees', 'designation_id')) {
                $table->foreignId('designation_id')->nullable()->constrained('designations')->nullOnDelete();
            }
            if (!Schema::hasColumn('employees', 'joining_date')) {
                $table->date('joining_date')->nullable();
            }
            if (!Schema::hasColumn('employees', 'status')) {
                $table->string('status')->default('active');
            }
            if (!Schema::hasColumn('employees', 'basic_salary')) {
                $table->decimal('basic_salary', 15, 2)->default(0.00);
            }
            if (!Schema::hasColumn('employees', 'hourly_rate')) {
                $table->decimal('hourly_rate', 10, 2)->default(0.00);
            }
            if (!Schema::hasColumn('employees', 'shift_type')) {
                $table->string('shift_type')->default('day');
            }
            if (!Schema::hasColumn('employees', 'address')) {
                $table->text('address')->nullable();
            }
            if (!Schema::hasColumn('employees', 'emergency_contact')) {
                $table->string('emergency_contact')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('employees', function (Blueprint $table) {
            $table->dropForeign(['department_id']);
            $table->dropForeign(['designation_id']);
            $table->dropColumn([
                'department_id',
                'designation_id',
                'joining_date',
                'status',
                'basic_salary',
                'hourly_rate',
                'shift_type',
                'address',
                'emergency_contact'
            ]);
        });

        Schema::dropIfExists('designations');
        Schema::dropIfExists('departments');
    }
};
