<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('customer_groups', function (Blueprint $table) {
            $table->integer('points_unit')->default(100)->after('description'); // e.g., 100 Points
            $table->decimal('currency_unit', 10, 2)->default(0)->after('points_unit'); // e.g., 10 EGP
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('customer_groups', function (Blueprint $table) {
            $table->dropColumn(['points_unit', 'currency_unit']);
        });
    }
};
