<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('quotations', function (Blueprint $table) {
            if (!Schema::hasColumn('quotations', 'discount_type')) {
                $table->enum('discount_type', ['fixed', 'percent'])->default('fixed')->after('terms');
            }
            if (!Schema::hasColumn('quotations', 'discount_value')) {
                $table->decimal('discount_value', 15, 2)->default(0)->after('discount_type');
            }
            if (!Schema::hasColumn('quotations', 'shipping_amount')) {
                $table->decimal('shipping_amount', 15, 2)->default(0)->after('discount_value');
            }
            if (!Schema::hasColumn('quotations', 'extra_expenses_amount')) {
                $table->decimal('extra_expenses_amount', 15, 2)->default(0)->after('shipping_amount');
            }
            if (!Schema::hasColumn('quotations', 'extra_expenses_note')) {
                $table->string('extra_expenses_note')->nullable()->after('extra_expenses_amount');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('quotations', function (Blueprint $table) {
            $columns = ['discount_type', 'discount_value', 'shipping_amount', 'extra_expenses_amount', 'extra_expenses_note'];
            $table->dropColumn(array_intersect($columns, Schema::getColumnListing('quotations')));
        });
    }
};
