<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Account;
use Illuminate\Support\Facades\DB;

class ChartOfAccountsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        DB::transaction(function () {
            // 1. Assets (الأصول)
            $assets = Account::create(['code' => '1000', 'name' => 'Assets', 'type' => 'asset']);

            // 1.1 Current Assets
            $currentAssets = Account::create(['code' => '1100', 'name' => 'Current Assets', 'type' => 'asset', 'parent_id' => $assets->id]);
            Account::create(['code' => '1101', 'name' => 'Cash on Hand', 'type' => 'asset', 'parent_id' => $currentAssets->id]);
            Account::create(['code' => '1102', 'name' => 'Bank Accounts', 'type' => 'asset', 'parent_id' => $currentAssets->id]);
            Account::create(['code' => '1103', 'name' => 'Accounts Receivable (Customers)', 'type' => 'asset', 'parent_id' => $currentAssets->id]);
            Account::create(['code' => '1104', 'name' => 'Inventory', 'type' => 'asset', 'parent_id' => $currentAssets->id]);

            // 1.2 Fixed Assets
            $fixedAssets = Account::create(['code' => '1200', 'name' => 'Fixed Assets', 'type' => 'asset', 'parent_id' => $assets->id]);
            Account::create(['code' => '1201', 'name' => 'Computers & Equipment', 'type' => 'asset', 'parent_id' => $fixedAssets->id]);
            Account::create(['code' => '1202', 'name' => 'Furniture', 'type' => 'asset', 'parent_id' => $fixedAssets->id]);

            // 2. Liabilities (الخصوم)
            $liabilities = Account::create(['code' => '2000', 'name' => 'Liabilities', 'type' => 'liability']);

            // 2.1 Current Liabilities
            $currentLiabilities = Account::create(['code' => '2100', 'name' => 'Current Liabilities', 'type' => 'liability', 'parent_id' => $liabilities->id]);
            Account::create(['code' => '2101', 'name' => 'Accounts Payable (Suppliers)', 'type' => 'liability', 'parent_id' => $currentLiabilities->id]);
            Account::create(['code' => '2102', 'name' => 'VAT Payable', 'type' => 'liability', 'parent_id' => $currentLiabilities->id]);

            // 3. Equity (حقوق الملكية)
            $equity = Account::create(['code' => '3000', 'name' => 'Equity', 'type' => 'equity']);
            Account::create(['code' => '3100', 'name' => 'Capital', 'type' => 'equity', 'parent_id' => $equity->id]);
            Account::create(['code' => '3200', 'name' => 'Retained Earnings', 'type' => 'equity', 'parent_id' => $equity->id]);

            // 4. Revenue (الإيرادات)
            $revenue = Account::create(['code' => '4000', 'name' => 'Revenue', 'type' => 'revenue']);
            Account::create(['code' => '4100', 'name' => 'Sales Services', 'type' => 'revenue', 'parent_id' => $revenue->id]);
            Account::create(['code' => '4200', 'name' => 'Hosting Revenue', 'type' => 'revenue', 'parent_id' => $revenue->id]);

            // 5. Expenses (المصروفات)
            $expenses = Account::create(['code' => '5000', 'name' => 'Expenses', 'type' => 'expense']);
            Account::create(['code' => '5100', 'name' => 'Cost of Goods Sold', 'type' => 'expense', 'parent_id' => $expenses->id]);
            Account::create(['code' => '5200', 'name' => 'Salaries & Wages', 'type' => 'expense', 'parent_id' => $expenses->id]);
            Account::create(['code' => '5300', 'name' => 'Rent Expense', 'type' => 'expense', 'parent_id' => $expenses->id]);
            Account::create(['code' => '5400', 'name' => 'Utilities (Internet/Electricity)', 'type' => 'expense', 'parent_id' => $expenses->id]);
            Account::create(['code' => '5500', 'name' => 'Maintenance', 'type' => 'expense', 'parent_id' => $expenses->id]);
        });
    }
}
