<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Unit;

class UnitsTableSeeder extends Seeder
{
    public function run()
    {
        // 1. Quantity Units
        // Base Unit: Piece (Habbah)
        Unit::create([
            'name' => 'Piece',
            'short_name' => 'pc', // or "حبة" localized later
            'type' => 'quantity',
            'is_active' => true,
        ]);

        // Base Unit: Service
        Unit::create([
            'name' => 'Service',
            'short_name' => 'svc',
            'type' => 'quantity', // Abstract quantity
            'is_active' => true,
        ]);

        // Weight
        $kg = Unit::create([
            'name' => 'Kilogram',
            'short_name' => 'kg',
            'type' => 'quantity',
            'is_active' => true,
        ]);

        Unit::create([
            'name' => 'Gram',
            'short_name' => 'g',
            'type' => 'quantity',
            'is_active' => true,
            'parent_id' => $kg->id,
            'conversion_factor' => 0.001,
        ]);

        // 2. Time Units
        Unit::create([
            'name' => 'Monthly',
            'short_name' => 'mo',
            'type' => 'time',
            'is_active' => true,
        ]);

        Unit::create([
            'name' => 'Quarterly',
            'short_name' => 'qtr',
            'type' => 'time',
            'is_active' => true,
        ]);

        Unit::create([
            'name' => 'Semi-Annually',
            'short_name' => 'hy',
            'type' => 'time',
            'is_active' => true,
        ]);

        Unit::create([
            'name' => 'Annually',
            'short_name' => 'yr',
            'type' => 'time',
            'is_active' => true,
        ]);

        Unit::create([
            'name' => 'One Time',
            'short_name' => 'once',
            'type' => 'quantity',
            'is_active' => true,
        ]);
    }
}
