<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class WhatsAppTemplateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $templates = [
            [
                'name' => 'New Invoice (Client)',
                'key' => 'client_invoice_new',
                'content' => "Dear {customer_name},\n\nHere is your invoice #{invoice_code} for {total} {currency}.\nDue Date: {due_date}\n\nView Invoice: {invoice_link}",
                'variables' => 'customer_name, invoice_code, total, currency, due_date, invoice_link'
            ],
            [
                'name' => 'Payment Received (Client)',
                'key' => 'client_payment_received',
                'content' => "Dear {customer_name},\n\nWe have received your payment of {amount} {currency} for invoice #{invoice_code}.\nYour remaining balance is {remaining} {currency}.\n\nThank you!",
                'variables' => 'customer_name, amount, currency, invoice_code, remaining'
            ],
            [
                'name' => 'Payroll Alert (Employee)',
                'key' => 'employee_payroll',
                'content' => "Hello {employee_name},\n\nYour salary for {month} has been generated.\nNet Salary: {net_salary} {currency}.\n\nYou can view your slip in the portal.",
                'variables' => 'employee_name, month, net_salary, currency'
            ],
            [
                'name' => 'License Info (Client)',
                'key' => 'client_license_info',
                'content' => "Hello {customer_name},\n\nYour license for *{software_name}* is:\n🔑 `{serial_key}`\n\nThank you for choosing us!",
                'variables' => 'customer_name, software_name, serial_key'
            ],
        ];

        foreach ($templates as $t) {
            \App\Models\WhatsAppTemplate::updateOrCreate(['key' => $t['key']], $t);
        }
    }
}
