# cPanel Deployment Guide

Deploying a Laravel 11 application on Shared Hosting (cPanel) requires specific steps due to the structured nature of shared environments.

## Step 1: File Preparation
1. Compress your project folder into a `.zip` file (exclude `node_modules`, `tests`, and `storage/framework/cache`).
2. Upload the zip file via cPanel File Manager to the root directory (one level above `public_html`).
3. Extract the files.

## Step 2: Public Folder Adjustment
Since cPanel uses `public_html` as the web root:
1. Move ALL contents of the `public` folder from your project into `public_html`.
2. Edit `public_html/index.php`:
   - Adjust the paths to point to your project folder:
     ```php
     // Before
     if (file_exists($maintenance = __DIR__.'/../storage/framework/maintenance.php')) {
         require $maintenance;
     }
     require __DIR__.'/../vendor/autoload.php';
     $app = require_once __DIR__.'/../bootstrap/app.php';

     // After (assuming project folder is named 'code_base')
     if (file_exists($maintenance = __DIR__.'/../code_base/storage/framework/maintenance.php')) {
         require $maintenance;
     }
     require __DIR__.'/../code_base/vendor/autoload.php';
     $app = require_once __DIR__.'/../code_base/bootstrap/app.php';
     ```

## Step 3: Environment Setup
1. Create a MySQL database and user in cPanel.
2. Edit the `.env` file in your project folder:
   - `APP_ENV=production`
   - `APP_DEBUG=false`
   - `APP_URL=https://your-domain.com`
   - `DB_DATABASE=your_db_name`
   - `DB_USERNAME=your_db_user`
   - `DB_PASSWORD=your_password`

## Step 4: Storage Symlink
Run this command via SSH or a Cron Job to link storage:
```bash
ln -s /home/your_cpanel_user/your_project_folder/storage/app/public /home/your_cpanel_user/public_html/storage
```

## Step 5: Database Migration & Setup (Wizard Installer)
Use the professional Wizard Installer to set up your system:
1. Navigate to `https://your-domain.com/install.php`.
2. The wizard will automatically check if your server meets the requirements.
3. Enter your Database Credentials (Host, Name, User, Password) as created in cPanel.
4. Click **Start Installation** to create tables and load initial data.
5. **IMPORTANT:** Delete `public/install.php` from your server immediately after use.

## Step 6: System Updates & Maintenance
If you need to run specific updates or clear cache later:
1. Use `https://your-domain.com/setup.php`.
2. This utility helps with maintenance tasks without needing SSH.
3. Keep this file only when needed, otherwise delete it for security.

## Step 7: Recurring Tasks (Cron Job)
Add a Cron Job in cPanel to run every minute for Recurring Invoices:
```bash
* * * * * cd /home/your_user/your_project_folder && php artisan schedule:run >> /dev/null 2>&1
```
