# SmartOne ERP - Developer Guide

## System Architecture
SmartOne is built on **Laravel 11**, utilizing a modular structure for Accounting, CRM, and HR.

## Key Models & Relationships

### 1. Customers & Financials
- **Customer**: Main entity for CRM.
    - `invoices()`: Has many Sales Invoices.
    - `walletTransactions()`: Tracks unallocated balance/prepayments.
    - `loyaltyTransactions()`: Tracks reward points.
- **Invoice**:
    - `items()`: Has many `InvoiceItem`.
    - `payments()`: Has many `FinancialTransaction` linked to a safe.
- **Treasury (Safe)**:
    - `transactions()`: Tracks all inbound/outbound cash flows.

### 2. HR & Projects
- **Employee**: Base model for staff.
    - `attendance()`: Daily logs.
    - `payrolls()`: Monthly salary records.
- **Project**:
    - `programmer()`: Linked to a User/Employee.
    - `client()`: Linked to a Customer.

## Security Implementation
- **SecurityHeaders Middleware**: Enforces CSP, X-Frame-Options, and XSS Protection.
- **Throttling**: Login and OTP attempts are limited (5 per minute).
- **HTTPS Enforcement**: Automatically forced in production environments via `AppServiceProvider`.

## PWA & Service Worker
- **Location**: `public/sw.js` and `public/manifest.json`.
- **Purpose**: Enables "Add to Home Screen" on mobile devices and basic offline caching for assets.

## Database Management
- Use `php artisan migrate` for schema updates.
- All financial transactions are logged in `financial_transactions` table with polymorphic links or safe IDs.
