# SmartOne ERP - System Overview

## Introduction
SmartOne ERP is a comprehensive Enterprise Resource Planning system built on Laravel, designed for businesses requiring integrated management of customers, financials, HR, and technical projects.

## Core Modules

### 1. CRM & Customers
- **Customer Management**: Centralized database for client information.
- **Loyalty System**: Automated point recording based on purchases.
- **Support Tickets**: Integrated helpdesk for client communication.

### 2. Finance & Accounting
- **Invoicing**: Advanced tax-compliant invoicing system with multi-payment options (Safe, Wallet, Loyalty).
- **Treasury Management**: Multi-safe and bank account tracking.
- **Expenses & Procurement**: Tracking operational costs and supplier payments.
- **Financial Reports**: Automated P/L reports (Accrual-based), VAT returns, and customer statements.

### 3. Subscriptions & Services
- **Recurring Invoices**: Automated billing for ongoing services.
- **Service Management**: Product and service portfolios with unit conversions.

### 4. HR & Payroll
- **Staff Records**: Comprehensive employee profiles.
- **Attendance**: Daily check-in/out tracking.
- **Automated Payroll**: Salary generation with allowances and deductions.

### 5. Project Management
- **Technical Projects**: Tracking software/technical project progress.
- **Programmer Management**: Linking developers to projects and tracking their commissions.

## Architecture Highlights
- **Framework**: Laravel 11.
- **Localization**: Full Arabic/English support.
- **PWA Ready**: Mobile-optimized service worker and manifest for Android/iOS.
- **Security**: Hardened with custom security headers and middleware.
