<?php

/**
 * SMARTONE ERP - Web Installer / Setup Utility
 * This script handles migrations and system setup for environments without SSH access.
 * SECURITY: Delete this file after successful installation.
 */

define('LARAVEL_START', microtime(true));

// 1. Check if maintenance mode is on or unauthorized
// For simplicity in this demo, we allow it, but in production, we'd add a security key check
// e.g. if ($_GET['key'] !== 'YOUR_SECRET_KEY') die('Unauthorized');

// 2. Load Laravel
require __DIR__ . '/../vendor/autoload.php';
$app = require_once __DIR__ . '/../bootstrap/app.php';

use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Schema;

$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إعداد نظام SMARTONE ERP</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <style>
        body {
            background: #0f172a;
            color: #fff;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        .setup-card {
            background: rgba(30, 41, 59, 0.7);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 20px;
            box-shadow: 0 20px 50px rgba(0, 0, 0, 0.5);
        }

        .btn-primary {
            background: linear-gradient(135deg, #6366f1, #a855f7);
            border: none;
            padding: 12px 30px;
            border-radius: 12px;
            font-weight: 600;
        }

        .log-area {
            background: #000;
            color: #0f0;
            padding: 15px;
            border-radius: 10px;
            font-family: monospace;
            height: 300px;
            overflow-y: auto;
            font-size: 0.9rem;
        }

        .success-accent {
            color: #10b981;
        }
    </style>
</head>

<body>
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-8 text-center">
                <h1 class="mb-4">SMARTONE <span class="success-accent">ERP</span></h1>
                <div class="card setup-card p-4">
                    <h3 class="mb-4">مثبت النظام (Web Installer)</h3>
                    <p class="text-muted mb-4">هذه الأداة مخصصة للاستضافات التي لا توفر الوصول عبر SSH (مثل cPanel
                        Shared Hosting).</p>

                    @if(isset($_POST['action']))
                    <div class="log-area text-start mb-4">
                        <?php
                        try {
                            if ($_POST['action'] === 'migrate') {
                                echo "> Running migrations...\n";
                                Artisan::call('migrate', ['--force' => true]);
                                echo Artisan::output();
                                echo "\n> Migrations completed successfully.\n";
                            } elseif ($_POST['action'] === 'link') {
                                echo "> Creating storage link...\n";
                                Artisan::call('storage:link');
                                echo Artisan::output();
                                echo "\n> Storage link created.\n";
                            } elseif ($_POST['action'] === 'clear') {
                                echo "> Clearing cache...\n";
                                Artisan::call('optimize:clear');
                                echo Artisan::output();
                                echo "\n> All caches cleared.\n";
                            }
                        } catch (\Exception $e) {
                            echo "\n[ERROR] " . $e->getMessage();
                        }
                        ?>
                    </div>
                    @endif

                    <form method="POST" class="d-grid gap-3">
                        <button type="submit" name="action" value="migrate" class="btn btn-primary">
                            <i class="fas fa-database me-2"></i> تشغيل التهجير (Run Migrations)
                        </button>
                        <button type="submit" name="action" value="link" class="btn btn-outline-info">
                            <i class="fas fa-link me-2"></i> ربط التخزين (Storage Link)
                        </button>
                        <button type="submit" name="action" value="clear" class="btn btn-outline-warning">
                            <i class="fas fa-sync me-2"></i> مسح التخزين المؤقت (Clear Cache)
                        </button>
                    </form>

                    <div class="mt-4 p-3 bg-danger bg-opacity-10 border border-danger rounded">
                        <small class="text-danger"><strong>تنبيه هامي:</strong> يرجى حذف هذا الملف (setup.php) فور
                            الانتهاء من عملية الإعداد لدواعي أمنية.</small>
                    </div>
                </div>
                <div class="mt-4">
                    <a href="/" class="text-decoration-none text-muted">العودة إلى النظام</a>
                </div>
            </div>
        </div>
    </div>
    <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>
</body>

</html>