@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="fw-light">{{ __('Record Purchase Bill') }}</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('accounting.bills.index') }}">{{ __('Bills') }}</a></li>
                    <li class="breadcrumb-item active">{{ __('Create') }}</li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="row justify-content-center">
        <div class="col-md-10">
            <form action="{{ route('accounting.bills.store') }}" method="POST">
                @csrf
                <div class="card mb-4">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">{{ __('Supplier') }} <span class="text-danger">*</span></label>
                                <select name="supplier_id" class="form-select" required>
                                    <option value="">{{ __('Select Supplier') }}</option>
                                    @foreach($suppliers as $supplier)
                                        <option value="{{ $supplier->id }}">{{ $supplier->name }}</option>
                                    @endforeach
                                </select>
                                <div class="form-text"><a
                                        href="{{ route('accounting.suppliers.create') }}">{{ __('Add new supplier') }}</a>
                                </div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">{{ __('Bill Number (Reference)') }}</label>
                                <input type="text" name="code" class="form-control" value="{{ $code }}" required>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">{{ __('Currency') }}</label>
                                <select name="currency_id" class="form-select">
                                    <option value="">{{ __('Default (System Base)') }}</option>
                                    @foreach($currencies as $currency)
                                        <option value="{{ $currency->id }}">{{ $currency->code }} - {{ $currency->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">{{ __('Exchange Rate') }}</label>
                                <input type="number" step="0.000001" name="exchange_rate" class="form-control"
                                    value="1.000000">
                                <small class="text-muted">{{ __('Rate relative to system base currency') }}</small>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">{{ __('Date') }} <span class="text-danger">*</span></label>
                                <input type="date" name="date" class="form-control" value="{{ date('Y-m-d') }}" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">{{ __('Due Date') }}</label>
                                <input type="date" name="due_date" class="form-control">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card mb-4">
                    <div class="card-header bg-dark border-secondary">
                        <h5 class="mb-0">{{ __('Bill Details') }}</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label class="form-label">{{ __('Subtotal (Before Tax)') }} <span
                                        class="text-danger">*</span></label>
                                <input type="number" step="0.01" name="subtotal" class="form-control" required>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">{{ __('Tax Amount (VAT)') }}</label>
                                <input type="number" step="0.01" name="tax_amount" class="form-control" value="0">
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">{{ __('Notes') }}</label>
                                <input type="text" name="notes" class="form-control"
                                    placeholder="{{ __('What was this for?') }}">
                            </div>
                        </div>
                    </div>
                    <div class="card-footer border-secondary text-end">
                        <button type="submit" class="btn btn-primary btn-lg">{{ __('Save Bill') }}</button>
                        <a href="{{ route('accounting.bills.index') }}"
                            class="btn btn-outline-secondary btn-lg">{{ __('Cancel') }}</a>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection