@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12 col-md-4">
            <h2 class="fw-light mb-0">{{ __('Purchases & Expenses') }}</h2>
            <p class="text-muted small">{{ __('Track supplier bills, payments, and outgoing cashflow') }}</p>
        </div>
        <div class="col-12 col-md-8 text-md-end">
            <a href="{{ route('accounting.bills.create') }}" class="btn btn-primary shadow-sm px-4">
                <i class="fas fa-plus-circle me-2"></i>{{ __('Record New Bill') }}
            </a>
        </div>
    </div>

    <!-- Stats Row -->
    <div class="row mb-4 g-3">
        <div class="col-6 col-lg-4">
            <div class="card stat-card h-100 border-start border-4 border-primary">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="bg-primary bg-opacity-10 p-2 rounded-3">
                            <i class="fas fa-file-invoice text-primary fa-lg"></i>
                        </div>
                        <span class="text-muted small">{{ __('Total Expenses') }}</span>
                    </div>
                    <h3 class="mb-0 fw-bold">{{ number_format($stats['total_value'], 2) }}</h3>
                    <div class="text-muted small mt-2">{{ __('Count') }}: {{ $stats['total_count'] }} {{ __('Bills') }}
                    </div>
                </div>
            </div>
        </div>
        <div class="col-6 col-lg-4">
            <div class="card stat-card h-100 border-start border-4 border-success">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="bg-success bg-opacity-10 p-2 rounded-3">
                            <i class="fas fa-check-double text-success fa-lg"></i>
                        </div>
                        <span class="text-muted small text-success">{{ __('Total Paid') }}</span>
                    </div>
                    <h3 class="mb-0 fw-bold text-success">{{ number_format($stats['paid_value'], 2) }}</h3>
                    <div class="progress mt-3" style="height: 4px;">
                        <div class="progress-bar bg-success"
                            style="width: {{ $stats['total_value'] > 0 ? ($stats['paid_value'] / $stats['total_value']) * 100 : 0 }}%">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12 col-lg-4">
            <div class="card stat-card h-100 border-start border-4 border-danger">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="bg-danger bg-opacity-10 p-2 rounded-3">
                            <i class="fas fa-hourglass-half text-danger fa-lg"></i>
                        </div>
                        <span class="text-muted small text-danger">{{ __('Unpaid Balance') }}</span>
                    </div>
                    <h3 class="mb-0 fw-bold text-danger">{{ number_format($stats['pending_value'], 2) }}</h3>
                    <div class="progress mt-3" style="height: 4px;">
                        <div class="progress-bar bg-danger"
                            style="width: {{ $stats['total_value'] > 0 ? ($stats['pending_value'] / $stats['total_value']) * 100 : 0 }}%">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-body p-0">
            <div class="table-responsive table-responsive-stack">
                <table class="table table-hover align-middle mb-0">
                    <thead class="table-dark">
                        <tr>
                            <th>{{ __('Date') }}</th>
                            <th>{{ __('Bill #') }}</th>
                            <th>{{ __('Supplier') }}</th>
                            <th class="text-end">{{ __('Amount') }}</th>
                            <th class="text-end">{{ __('Paid') }}</th>
                            <th class="text-center">{{ __('Status') }}</th>
                            <th>{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($bills as $bill)
                            <tr>
                                <td data-label="{{ __('Date') }}">{{ $bill->date->format('Y-m-d') }}</td>
                                <td data-label="{{ __('Bill #') }}">{{ $bill->code }}</td>
                                <td data-label="{{ __('Supplier') }}" class="fw-bold">{{ $bill->supplier->name }}</td>
                                <td data-label="{{ __('Amount') }}" class="text-end fw-bold">
                                    {{ number_format($bill->total, 2) }}</td>
                                <td data-label="{{ __('Paid') }}" class="text-end text-success">
                                    {{ number_format($bill->paid_amount, 2) }}</td>
                                <td data-label="{{ __('Status') }}" class="text-center">
                                    @if($bill->status == 'paid')
                                        <span class="badge bg-success">{{ __('paid') }}</span>
                                    @elseif($bill->status == 'partial')
                                        <span class="badge bg-warning text-dark">{{ __('partial') }}</span>
                                    @else
                                        <span class="badge bg-secondary">{{ __('unpaid') }}</span>
                                    @endif
                                </td>
                                <td data-label="{{ __('Actions') }}">
                                    <a href="{{ route('accounting.bills.show', $bill) }}" class="btn btn-sm btn-outline-info">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center py-5">
                                    <i class="fas fa-file-invoice fa-3x text-muted mb-3"></i>
                                    <h3>{{ __('No bills recorded') }}</h3>
                                    <p class="text-muted">{{ __('Record your expenses and purchase invoices here.') }}</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        @if($bills->hasPages())
            <div class="card-footer">
                {{ $bills->links() }}
            </div>
        @endif
    </div>
@endsection