@extends('layouts.print_a4')

@section('title', 'Bill #' . $bill->code)
@section('doc_title', 'فاتورة مشتريات (Purchase Bill)')

@section('content')
    <div class="doc-meta">
        <div>رقم الفاتورة: <strong>{{ $bill->code }}</strong></div>
        <div>تاريخ الفاتورة: <strong>{{ $bill->date->format('Y-m-d') }}</strong></div>
        <div>تاريخ الاستحقاق: <strong>{{ $bill->due_date ? $bill->due_date->format('Y-m-d') : '-' }}</strong></div>
    </div>

    <div class="bill-to" style="display: flex; justify-content: space-between; margin-bottom: 20px;">
        <div style="width: 48%; border: 1px solid #ddd; padding: 10px; background: #f9f9f9;">
            <h5 style="margin-top: 0; border-bottom: 1px solid #ccc; padding-bottom: 5px;">بيانات المورد (Supplier Info)
            </h5>
            <strong>{{ $bill->supplier->name }}</strong><br>
            {{ $bill->supplier->company_name }}<br>
            {{ $bill->supplier->phone }}
        </div>
        <div style="width: 48%; border: 1px solid #ddd; padding: 10px;">
            <h5 style="margin-top: 0; border-bottom: 1px solid #ccc; padding-bottom: 5px;">حالة الفاتورة (Status)</h5>
            @if($bill->status == 'paid')
                <span style="color: green; font-weight: bold; font-size: 20px;">مدفوعة (PAID)</span>
            @elseif($bill->status == 'partial')
                <span style="color: orange; font-weight: bold;">مدفوعة جزئياً (PARTIAL)</span>
            @else
                <span style="color: red; font-weight: bold;">غير مدفوعة (UNPAID)</span>
            @endif
        </div>
    </div>

    <table class="table">
        <thead>
            <tr>
                <th>البيان (Description)</th>
                <th>الإجمالي (Amount)</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td style="text-align: right;">فاتورة مشتريات رقم {{ $bill->code }}</td>
                <td>{{ number_format($bill->subtotal, 2) }}</td>
            </tr>
        </tbody>
    </table>

    <div class="totals-section" style="float: left; width: 300px;">
        <table class="totals-table">
            <tr>
                <td>الاجمالي الفرعي (Subtotal):</td>
                <td style="text-align: left;">{{ number_format($bill->subtotal, 2) }}</td>
            </tr>
            @if($bill->tax_amount > 0)
                <tr>
                    <td>ضريبة القيمه المضافة (VAT):</td>
                    <td style="text-align: left;">{{ number_format($bill->tax_amount, 2) }}</td>
                </tr>
            @endif
            <tr class="total-row">
                <td>الإجمالي الكلي (Total):</td>
                <td style="text-align: left;">{{ number_format($bill->total, 2) }} ج.م</td>
            </tr>
            <tr>
                <td>المدفوع (Paid):</td>
                <td style="text-align: left;">{{ number_format($bill->paid_amount, 2) }}</td>
            </tr>
            <tr style="border-top: 1px solid #000;">
                <td><strong>المتبقي (Balance Due):</strong></td>
                <td style="text-align: left;"><strong>{{ number_format($bill->total - $bill->paid_amount, 2) }} ج.م</strong>
                </td>
            </tr>
        </table>
    </div>

    <div style="clear: both; margin-top: 40px;">
        <p><strong>ملاحظات:</strong> {{ $bill->notes ?: '-' }}</p>
    </div>

    <div class="signature-section">
        <div class="signature-box">
            المحاسب
            <div class="signature-line"></div>
        </div>
        <div class="signature-box">
            المدير المالي
            <div class="signature-line"></div>
        </div>
    </div>
@endsection