@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12 col-md-6">
            <h2 class="fw-light">Bill #{{ $bill->code }}</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('accounting.bills.index') }}">Bills</a></li>
                    <li class="breadcrumb-item active">{{ $bill->code }}</li>
                </ol>
            </nav>
        </div>
        <div class="col-12 col-md-6 text-md-end">
            @if($bill->status != 'paid')
                <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#paymentModal">
                    <i class="fas fa-money-bill-wave me-2"></i>Record Payment
                </button>
            @endif
            @if($bill->status != 'cancelled' && $bill->paid_amount == 0)
                <form action="{{ route('accounting.bills.cancel', $bill) }}" method="POST" class="d-inline"
                    onsubmit="return confirm('Are you sure you want to cancel this bill?')">
                    @csrf
                    <button type="submit" class="btn btn-outline-danger me-2">
                        <i class="fas fa-times me-2"></i>Cancel
                    </button>
                </form>
            @endif
            <a href="{{ route('accounting.bills.print', $bill) }}" target="_blank" class="btn btn-outline-light">
                <i class="fas fa-print me-2"></i>Premium A4 Print
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <div class="card mb-4">
                <div class="card-body">
                    <div class="row mb-4">
                        <div class="col-sm-6">
                            <h6 class="mb-3">From Supplier:</h6>
                            <h5>{{ $bill->supplier->name }}</h5>
                            <div>{{ $bill->supplier->address }}</div>
                            <div>{{ $bill->supplier->email }}</div>
                            <div>{{ $bill->supplier->phone }}</div>
                            <div>Tax ID: {{ $bill->supplier->tax_id ?? 'N/A' }}</div>
                        </div>
                        <div class="col-sm-6 text-sm-end">
                            <h6 class="mb-3">Bill Details:</h6>
                            <h3 class="text-primary">{{ $bill->code }}</h3>
                            <div>Date: {{ $bill->date->format('Y-m-d') }}</div>
                            <div>Due Date: {{ $bill->due_date ? $bill->due_date->format('Y-m-d') : 'Immediate' }}</div>
                            <div class="mt-2">
                                Status:
                                <span
                                    class="badge {{ $bill->status == 'paid' ? 'bg-success' : ($bill->status == 'partial' ? 'bg-warning' : 'bg-danger') }}">
                                    {{ ucfirst($bill->status) }}
                                </span>
                            </div>
                            <div class="mt-2 text-muted small">
                                Currency: {{ $bill->currency ? $bill->currency->code : 'Base' }}
                            </div>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Description</th>
                                    <th class="text-end">Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Bill Subtotal</td>
                                    <td class="text-end">{{ number_format($bill->subtotal, 2) }}</td>
                                </tr>
                                <tr>
                                    <td>Tax (VAT)</td>
                                    <td class="text-end">{{ number_format($bill->tax_amount, 2) }}</td>
                                </tr>
                                <tr class="fw-bold fs-5">
                                    <td>Total Amount</td>
                                    <td class="text-end text-primary">{{ number_format($bill->total, 2) }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="card mb-4">
                <div class="card-header bg-dark border-secondary">
                    <h5 class="mb-0">Payment History</h5>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <th>Date</th>
                                    <th>Treasury</th>
                                    <th class="text-end">Amount</th>
                                    <th class="text-end">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($bill->transactions as $trans)
                                    <tr>
                                        <td>{{ $trans->date->format('Y-m-d') }}</td>
                                        <td>{{ $trans->treasury->name }}</td>
                                        <td class="text-end fw-bold">{{ number_format($trans->amount, 2) }}</td>
                                        <td class="text-end">
                                            <form action="{{ route('accounting.bills.transactions.destroy', [$bill, $trans]) }}"
                                                method="POST" class="d-inline"
                                                onsubmit="return confirm('Reverse this payment?')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-outline-danger"><i
                                                        class="fas fa-trash"></i></button>
                                            </form>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="4" class="text-center py-3 text-muted">No payments recorded yet.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card mb-4">
                <div class="card-header bg-dark border-secondary">
                    <h5 class="mb-0">Payment Context</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between mb-2">
                        <span>Total Due:</span>
                        <span class="fw-bold">{{ number_format($bill->total, 2) }}</span>
                    </div>
                    <div class="d-flex justify-content-between mb-2 text-success">
                        <span>Amount Paid:</span>
                        <span class="fw-bold">- {{ number_format($bill->paid_amount, 2) }}</span>
                    </div>
                    <hr class="border-secondary">
                    <div class="d-flex justify-content-between mb-2">
                        <span class="fs-5">Balance Remaining:</span>
                        <span
                            class="fs-5 fw-bold text-danger">{{ number_format($bill->total - $bill->paid_amount, 2) }}</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Payment Modal -->
    <div class="modal fade" id="paymentModal" tabindex="-1">
        <div class="modal-dialog">
            <form action="{{ route('accounting.bills.payment', $bill) }}" method="POST">
                @csrf
                <div class="modal-content bg-dark">
                    <div class="modal-header border-secondary">
                        <h5 class="modal-title">Record Outgoing Payment</h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">Payment Amount</label>
                            <div class="input-group">
                                <span class="input-group-text">EGP</span>
                                <input type="number" step="0.01" name="amount" class="form-control"
                                    value="{{ $bill->total - $bill->paid_amount }}"
                                    max="{{ $bill->total - $bill->paid_amount }}" required>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Paid From (Treasury)</label>
                            <select name="treasury_id" class="form-select" required>
                                @foreach($treasuries as $treasury)
                                    <option value="{{ $treasury->id }}">{{ $treasury->name }}
                                        ({{ number_format($treasury->balance, 2) }})</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Date</label>
                            <input type="date" name="date" class="form-control" value="{{ date('Y-m-d') }}" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">{{ __('Exchange Rate') }}</label>
                            <input type="number" step="0.000001" name="exchange_rate" class="form-control"
                                placeholder="1.0">
                            <small
                                class="text-muted">{{ __('Required if Treasury currency differs from Bill currency. (Amount / Rate = Bill Credit)') }}</small>
                        </div>
                    </div>
                    <div class="modal-footer border-secondary">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-success">Confirm Payment</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection