@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12 col-md-6">
            <h2 class="fw-light">Currency Management (إدارة العملات)</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('settings.index') }}">Settings</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Currencies</li>
                </ol>
            </nav>
        </div>
        <div class="col-12 col-md-6 text-md-end">
            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addCurrencyModal">
                <i class="fas fa-plus-circle me-2"></i>Add Currency
            </button>
        </div>
    </div>

    <div class="card">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0 align-middle">
                    <thead class="table-dark">
                        <tr>
                            <th>Code</th>
                            <th>Name</th>
                            <th>Symbol</th>
                            <th>Exchange Rate (1 Base = ?)</th>
                            <th>Status</th>
                            <th class="text-end">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($currencies as $currency)
                            <tr class="{{ $currency->is_base ? 'bg-secondary bg-opacity-10' : '' }}">
                                <td>
                                    <span class="fw-bold">{{ $currency->code }}</span>
                                    @if($currency->is_base)
                                        <span class="badge bg-success ms-1">Base</span>
                                    @endif
                                </td>
                                <td>{{ $currency->name }}</td>
                                <td>{{ $currency->symbol }}</td>
                                <td>
                                    {{ number_format($currency->exchange_rate, 4) }}
                                    <small class="text-muted d-block">1 {{ \App\Models\Currency::getBase()->code }} =
                                        {{ number_format($currency->exchange_rate, 4) }} {{ $currency->code }}</small>
                                </td>
                                <td>
                                    <span class="badge bg-{{ $currency->is_active ? 'success' : 'danger' }}">
                                        {{ $currency->is_active ? 'Active' : 'Inactive' }}
                                    </span>
                                </td>
                                <td class="text-end">
                                    <button class="btn btn-sm btn-outline-light" data-bs-toggle="modal"
                                        data-bs-target="#editCurrencyModal{{ $currency->id }}">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    @if(!$currency->is_base)
                                        <form action="{{ route('accounting.currencies.destroy', $currency) }}" method="POST"
                                            class="d-inline">
                                            @csrf @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-outline-danger border-0"
                                                onclick="return confirm('Delete currency?')">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    @endif
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center py-5 text-muted">No currencies configured.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Edit Modals -->
    @foreach($currencies as $currency)
        <div class="modal fade" id="editCurrencyModal{{ $currency->id }}" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content bg-dark border-secondary text-white">
                    <form action="{{ route('accounting.currencies.update', $currency) }}" method="POST">
                        @csrf @method('PUT')
                        <div class="modal-header border-secondary text-start">
                            <h5 class="modal-title">Edit Currency: {{ $currency->code }} (Update)</h5>
                            <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                        </div>
                        <div class="modal-body text-start">
                            <div class="mb-3">
                                <label class="form-label">Currency Name</label>
                                <input type="text" name="name" class="form-control" value="{{ $currency->name }}" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Symbol</label>
                                <input type="text" name="symbol" class="form-control" value="{{ $currency->symbol }}" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Exchange Rate (vs Base)</label>
                                <input type="number" name="exchange_rate" class="form-control" step="any"
                                    value="{{ $currency->exchange_rate }}" required>
                            </div>
                            <div class="form-check form-switch mb-3">
                                <input class="form-check-input" type="checkbox" name="is_base" value="1"
                                    {{ $currency->is_base ? 'checked disabled' : '' }}>
                                <label class="form-check-label">Set as Base Currency</label>
                            </div>
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="is_active" value="1"
                                    {{ $currency->is_active ? 'checked' : '' }}>
                                <label class="form-check-label">Active</label>
                            </div>
                        </div>
                        <div class="modal-footer border-secondary">
                            <button type="button" class="btn btn-outline-light" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Update Currency</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endforeach

    <!-- Add Modal -->
    <div class="modal fade" id="addCurrencyModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content bg-dark border-secondary text-white">
                <form action="{{ route('accounting.currencies.store') }}" method="POST">
                    @csrf
                    <div class="modal-header border-secondary text-start">
                        <h5 class="modal-title">Add New Currency</h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body text-start">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">ISO Code</label>
                                <input type="text" name="code" class="form-control" placeholder="e.g. USD" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Symbol</label>
                                <input type="text" name="symbol" class="form-control" placeholder="e.g. $" required>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Currency Name</label>
                            <input type="text" name="name" class="form-control" placeholder="e.g. US Dollar" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Exchange Rate (1 Base = ? Units)</label>
                            <input type="number" name="exchange_rate" class="form-control" step="0.000001"
                                placeholder="e.g. 50.00" required>
                        </div>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" name="is_base" value="1">
                            <label class="form-check-label">Set as Base Currency</label>
                        </div>
                    </div>
                    <div class="modal-footer border-secondary">
                        <button type="button" class="btn btn-outline-light" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Create Currency</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection