@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="page-header mb-4">
        <h1 class="page-title">{{ __('Record New Expense') }}</h1>
        <p class="page-subtitle">{{ __('Add a generalized expense transaction') }}</p>
    </div>

    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="card glass-card premium-shadow">
                <div class="card-body p-4">
                    <form action="{{ route('accounting.expenses.store') }}" method="POST">
                        @csrf
                        
                        <div class="row g-4">
                            <!-- Category Selection -->
                            <div class="col-md-6">
                                <label class="form-label fw-bold">{{ __('Expense Category') }} <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text bg-transparent border-end-0 text-muted"><i class="fas fa-tags"></i></span>
                                    <select name="category_id" class="form-select border-start-0" required>
                                        <option value="">{{ __('Select Category') }}</option>
                                        @foreach($categories as $category)
                                            <option value="{{ $category->id }}" {{ old('category_id') == $category->id ? 'selected' : '' }}>
                                                {{ $category->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-text small">{{ __('Categories like: Rent, Salaries, Electricity, etc.') }}</div>
                                @error('category_id') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                            </div>

                            <!-- Treasury Selection -->
                            <div class="col-md-6">
                                <label class="form-label fw-bold">{{ __('Pay From (Treasury)') }} <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text bg-transparent border-end-0 text-muted"><i class="fas fa-vault"></i></span>
                                    <select name="treasury_id" class="form-select border-start-0" required id="treasurySelect">
                                        <option value="">{{ __('Select Treasury') }}</option>
                                        @foreach($treasuries as $treasury)
                                            <option value="{{ $treasury->id }}" 
                                                    data-balance="{{ $treasury->balance }}"
                                                    data-currency="{{ $treasury->currency->code ?? '' }}"
                                                    {{ old('treasury_id') == $treasury->id ? 'selected' : '' }}>
                                                {{ $treasury->name }} ({{ number_format($treasury->balance, 2) }} {{ $treasury->currency->code ?? '' }})
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div id="balanceWarning" class="text-warning small mt-1 d-none">
                                    <i class="fas fa-exclamation-triangle me-1"></i> {{ __('Amount exceeds available balance!') }}
                                </div>
                                @error('treasury_id') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                            </div>

                            <!-- Amount -->
                            <div class="col-md-6">
                                <label class="form-label fw-bold">{{ __('Amount') }} <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text bg-transparent border-end-0 text-muted"><i class="fas fa-dollar-sign"></i></span>
                                    <input type="number" step="0.01" name="amount" id="amountInput" class="form-control border-start-0" placeholder="0.00" value="{{ old('amount') }}" required>
                                </div>
                                @error('amount') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                            </div>

                            <!-- Date -->
                            <div class="col-md-6">
                                <label class="form-label fw-bold">{{ __('Expense Date') }} <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text bg-transparent border-end-0 text-muted"><i class="fas fa-calendar"></i></span>
                                    <input type="date" name="date" class="form-control border-start-0" value="{{ old('date', date('Y-m-d')) }}" required>
                                </div>
                                @error('date') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                            </div>

                            <!-- Reference Number -->
                            <div class="col-md-12">
                                <label class="form-label fw-bold">{{ __('Reference / Receipt No.') }}</label>
                                <div class="input-group">
                                    <span class="input-group-text bg-transparent border-end-0 text-muted"><i class="fas fa-hashtag"></i></span>
                                    <input type="text" name="ref_no" class="form-control border-start-0" placeholder="{{ __('Optional reference number') }}" value="{{ old('ref_no') }}">
                                </div>
                            </div>

                            <!-- Description -->
                            <div class="col-12">
                                <label class="form-label fw-bold">{{ __('Description / Statement') }} <span class="text-danger">*</span></label>
                                <textarea name="description" class="form-control" rows="3" placeholder="{{ __('Write a detailed description of the expense...') }}" required>{{ old('description') }}</textarea>
                                @error('description') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                            </div>

                            <!-- Submit Buttons -->
                            <div class="col-12 mt-4">
                                <hr class="border-secondary opacity-25">
                                <div class="d-flex justify-content-between">
                                    <a href="{{ route('accounting.expenses.index') }}" class="btn btn-outline-secondary px-4 glass-card">
                                        <i class="fas fa-times me-2"></i> {{ __('Cancel') }}
                                    </a>
                                    <button type="submit" class="btn btn-primary px-5 premium-shadow">
                                        <i class="fas fa-save me-2"></i> {{ __('Record Expense') }}
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const treasurySelect = document.getElementById('treasurySelect');
        const amountInput = document.getElementById('amountInput');
        const balanceWarning = document.getElementById('balanceWarning');

        function checkBalance() {
            const selected = treasurySelect.options[treasurySelect.selectedIndex];
            if (!selected || !selected.value) return;

            const balance = parseFloat(selected.dataset.balance);
            const amount = parseFloat(amountInput.value) || 0;

            if (amount > balance) {
                balanceWarning.classList.remove('d-none');
            } else {
                balanceWarning.classList.add('d-none');
            }
        }

        treasurySelect.addEventListener('change', checkBalance);
        amountInput.addEventListener('input', checkBalance);
    });
</script>
@endsection
