@extends('layouts.app')

@section('content')
    <div class="container-fluid">
        <div class="page-header d-flex justify-content-between align-items-center">
            <div>
                <h1 class="page-title">{{ __('General Expenses') }}</h1>
                <p class="page-subtitle">{{ __('Manage your operational daily expenses') }}</p>
            </div>
            <a href="{{ route('accounting.expenses.create') }}" class="btn btn-primary premium-shadow">
                <i class="fas fa-plus me-2"></i> {{ __('Record New Expense') }}
            </a>
        </div>

        <!-- Stats Cards -->
        <div class="row g-3 mb-4">
            <div class="col-md-6 col-lg-3">
                <div class="stat-card orange">
                    <div class="stat-icon">
                        <i class="fas fa-money-bill-wave"></i>
                    </div>
                    <div class="stat-value">{{ number_format($stats['total_amount'], 2) }}</div>
                    <div class="stat-label">{{ __('Total Expenses') }}</div>
                </div>
            </div>
            <div class="col-md-6 col-lg-3">
                <div class="stat-card purple">
                    <div class="stat-icon">
                        <i class="fas fa-list-ol"></i>
                    </div>
                    <div class="stat-value">{{ $stats['count'] }}</div>
                    <div class="stat-label">{{ __('Transaction Count') }}</div>
                </div>
            </div>
        </div>

        <!-- Filters -->
        <div class="card glass-card mb-4">
            <div class="card-body">
                <form action="{{ route('accounting.expenses.index') }}" method="GET" class="row g-3">
                    <div class="col-md-3">
                        <label class="form-label">{{ __('Category') }}</label>
                        <select name="category_id" class="form-select">
                            <option value="">{{ __('All Categories') }}</option>
                            @foreach($categories as $category)
                                <option value="{{ $category->id }}" {{ request('category_id') == $category->id ? 'selected' : '' }}>
                                    {{ $category->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">{{ __('Treasury') }}</label>
                        <select name="treasury_id" class="form-select">
                            <option value="">{{ __('All Treasuries') }}</option>
                            @foreach($treasuries as $treasury)
                                <option value="{{ $treasury->id }}" {{ request('treasury_id') == $treasury->id ? 'selected' : '' }}>
                                    {{ $treasury->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">{{ __('From') }}</label>
                        <input type="date" name="date_from" class="form-control" value="{{ request('date_from') }}">
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">{{ __('To') }}</label>
                        <input type="date" name="date_to" class="form-control" value="{{ request('date_to') }}">
                    </div>
                    <div class="col-md-2 d-flex align-items-end">
                        <div class="btn-group w-100">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-filter"></i>
                            </button>
                            <a href="{{ route('accounting.expenses.index') }}" class="btn btn-outline-secondary">
                                <i class="fas fa-undo"></i>
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Expenses Table -->
        <div class="card glass-card">
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead>
                            <tr>
                                <th>{{ __('Date') }}</th>
                                <th>{{ __('Category') }}</th>
                                <th>{{ __('Reference') }}</th>
                                <th>{{ __('Treasury') }}</th>
                                <th>{{ __('Description') }}</th>
                                <th>{{ __('Amount') }}</th>
                                <th class="text-end">{{ __('Actions') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($expenses as $expense)
                                <tr>
                                    <td>{{ \Carbon\Carbon::parse($expense->date)->format('Y-m-d') }}</td>
                                    <td>
                                        <span class="badge bg-soft-info text-info">
                                            {{ $expense->category->name ?? __('Uncategorized') }}
                                        </span>
                                    </td>
                                    <td><code class="text-muted">{{ $expense->ref_no ?? '---' }}</code></td>
                                    <td>{{ $expense->treasury->name ?? '---' }}</td>
                                    <td>{{ Str::limit($expense->description, 50) }}</td>
                                    <td class="fw-bold text-danger">
                                        {{ number_format($expense->amount, 2) }} {{ $expense->treasury->currency->code ?? '' }}
                                    </td>
                                    <td class="text-end">
                                        <form action="{{ route('accounting.expenses.destroy', $expense) }}" method="POST"
                                            class="d-inline"
                                            onsubmit="return confirm('{{ __('Are you sure you want to delete this expense? This will revert the treasury balance.') }}')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-outline-danger">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="7" class="text-center py-4 text-muted">
                                        <i class="fas fa-receipt fa-3x mb-3 d-block"></i>
                                        {{ __('No expenses found for the selected criteria.') }}
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
            @if($expenses->hasPages())
                <div class="card-footer glass-card-footer">
                    {{ $expenses->links() }}
                </div>
            @endif
        </div>
    </div>

    <style>
        .bg-soft-info {
            background-color: rgba(0, 212, 255, 0.1);
            color: #00d4ff;
        }
    </style>
@endsection