@extends('layouts.app')

@section('content')
<div class="row mb-4">
    <div class="col-12 col-md-4">
        <h2 class="fw-light mb-0">{{ __('Invoices') }}</h2>
        <p class="text-muted small">{{ __('Manage billing, payments, and client receivables') }}</p>
    </div>
    <div class="col-12 col-md-8 text-md-end">
        <a href="{{ route('accounting.invoices.sync-whmcs') }}" class="btn btn-outline-info me-2">
            <i class="fas fa-sync me-2"></i>{{ __('Sync WHMCS') }}
        </a>
        <a href="{{ route('accounting.invoices.create') }}" class="btn btn-primary shadow-sm px-4">
            <i class="fas fa-plus-circle me-2"></i>{{ __('New Invoice') }}
        </a>
    </div>
</div>

<!-- Stats Row -->
<div class="row mb-4 g-3">
    <div class="col-6 col-lg-3">
        <div class="card stat-card h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <div class="bg-primary bg-opacity-10 p-2 rounded-3">
                        <i class="fas fa-file-invoice text-primary fa-lg"></i>
                    </div>
                    <span class="text-muted small">{{ __('Total Invoices') }}</span>
                </div>
                <h3 class="mb-0 fw-bold">{{ $stats['total_count'] }}</h3>
                <div class="text-muted small mt-2">{{ __('Value') }}: {{ number_format($stats['total_value'], 2) }}</div>
            </div>
        </div>
    </div>
    <div class="col-6 col-lg-3">
        <div class="card stat-card h-100 border-start border-4 border-success">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <div class="bg-success bg-opacity-10 p-2 rounded-3">
                        <i class="fas fa-money-check-dollar text-success fa-lg"></i>
                    </div>
                    <span class="text-muted small text-success">{{ __('Collected') }}</span>
                </div>
                <h3 class="mb-0 fw-bold text-success">{{ number_format($stats['paid_value'], 2) }}</h3>
                <div class="progress mt-3" style="height: 4px;">
                    <div class="progress-bar bg-success" style="width: {{ $stats['total_value'] > 0 ? ($stats['paid_value'] / $stats['total_value']) * 100 : 0 }}%"></div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-6 col-lg-3">
        <div class="card stat-card h-100 border-start border-4 border-danger">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <div class="bg-danger bg-opacity-10 p-2 rounded-3">
                        <i class="fas fa-clock text-danger fa-lg"></i>
                    </div>
                    <span class="text-muted small text-danger">{{ __('Pending') }}</span>
                </div>
                <h3 class="mb-0 fw-bold text-danger">{{ number_format($stats['pending_value'], 2) }}</h3>
                <div class="progress mt-3" style="height: 4px;">
                    <div class="progress-bar bg-danger" style="width: {{ $stats['total_value'] > 0 ? ($stats['pending_value'] / $stats['total_value']) * 100 : 0 }}%"></div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-6 col-lg-3">
        <div class="card stat-card h-100 border-start border-4 border-info">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <div class="bg-info bg-opacity-10 p-2 rounded-3">
                        <i class="fas fa-calendar-day text-info fa-lg"></i>
                    </div>
                    <span class="text-muted small text-info">{{ __('Due Today') }}</span>
                </div>
                <h3 class="mb-0 fw-bold">{{ $stats['due_today_count'] }}</h3>
                <div class="text-muted small mt-2">{{ __('Value') }}: {{ number_format($stats['due_today_value'], 2) }}</div>
            </div>
        </div>
    </div>
</div>

<!-- Filter Tabs -->
<div class="card mb-4">
    <div class="card-body py-2">
        <div class="d-flex flex-wrap gap-2 align-items-center">
        <div class="d-flex flex-wrap gap-2 align-items-center mb-2">
            <span class="text-muted small me-2">{{ __('Filter by Status') }}:</span>
            <a href="{{ route('accounting.invoices.index', array_merge(request()->except('status'), [])) }}" 
               class="btn btn-sm {{ !request('status') ? 'btn-primary' : 'btn-outline-secondary' }}">
                {{ __('All') }} <span class="badge bg-light text-dark ms-1">{{ $statusCounts['all'] ?? 0 }}</span>
            </a>
            <a href="{{ route('accounting.invoices.index', array_merge(request()->all(), ['status' => 'unpaid'])) }}" 
               class="btn btn-sm {{ request('status') == 'unpaid' ? 'btn-warning' : 'btn-outline-warning' }}">
                {{ __('Unpaid') }} <span class="badge bg-light text-dark ms-1">{{ $statusCounts['unpaid'] ?? 0 }}</span>
            </a>
            <a href="{{ route('accounting.invoices.index', array_merge(request()->all(), ['status' => 'partial'])) }}" 
               class="btn btn-sm {{ request('status') == 'partial' ? 'btn-info' : 'btn-outline-info' }}">
                {{ __('Partial') }} <span class="badge bg-light text-dark ms-1">{{ $statusCounts['partial'] ?? 0 }}</span>
            </a>
            <a href="{{ route('accounting.invoices.index', array_merge(request()->all(), ['status' => 'paid'])) }}" 
               class="btn btn-sm {{ request('status') == 'paid' ? 'btn-success' : 'btn-outline-success' }}">
                {{ __('Paid') }} <span class="badge bg-light text-dark ms-1">{{ $statusCounts['paid'] ?? 0 }}</span>
            </a>
            <a href="{{ route('accounting.invoices.index', array_merge(request()->all(), ['status' => 'cancelled'])) }}" 
               class="btn btn-sm {{ request('status') == 'cancelled' ? 'btn-danger' : 'btn-outline-danger' }}">
                {{ __('Cancelled') }} <span class="badge bg-light text-dark ms-1">{{ $statusCounts['cancelled'] ?? 0 }}</span>
            </a>
            <a href="{{ route('accounting.invoices.index', array_merge(request()->all(), ['status' => 'draft'])) }}" 
               class="btn btn-sm {{ request('status') == 'draft' ? 'btn-secondary' : 'btn-outline-secondary' }}">
                {{ __('Draft') }} <span class="badge bg-light text-dark ms-1">{{ $statusCounts['draft'] ?? 0 }}</span>
            </a>
        </div>
        <div class="d-flex flex-wrap gap-2 align-items-center">
            <span class="text-muted small me-2">{{ __('Filter by Tax Type') }}:</span>
            <a href="{{ route('accounting.invoices.index', array_merge(request()->except('is_tax_invoice'), [])) }}" 
               class="btn btn-sm {{ request('is_tax_invoice') === null ? 'btn-primary' : 'btn-outline-secondary' }}">
                {{ __('All Invoices') }}
            </a>
            <a href="{{ route('accounting.invoices.index', array_merge(request()->all(), ['is_tax_invoice' => 0])) }}" 
               class="btn btn-sm {{ request('is_tax_invoice') === '0' ? 'btn-info' : 'btn-outline-info' }}">
                {{ __('Normal Invoices') }}
            </a>
            <a href="{{ route('accounting.invoices.index', array_merge(request()->all(), ['is_tax_invoice' => 1])) }}" 
               class="btn btn-sm {{ request('is_tax_invoice') === '1' ? 'btn-danger' : 'btn-outline-danger' }}">
                <i class="fas fa-file-invoice-dollar me-1"></i> {{ __('Show Only Tax Invoices') }}
            </a>
        </div>
        </div>
    </div>
</div>

<div class="card">

    <div class="card-body p-0">
        <div class="table-responsive table-responsive-stack">
            <table class="table table-hover align-middle mb-0">
                <thead class="table-dark">
                    <tr>
                        <th>{{ __('Status') }}</th>
                        <th>{{ __('Code') }}</th>
                        <th>{{ __('Client') }}</th>
                        <th>{{ __('Salesperson') }}</th>
                        <th>{{ __('Date') }}</th>
                        <th>{{ __('Due Date') }}</th>
                        <th class="text-end">{{ __('Amount') }}</th>
                        <th>{{ __('Last Updated') }}</th>
                        <th class="text-end">{{ __('Actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($invoices as $invoice)
                    <tr>
                        <td data-label="{{ __('Status') }}">
                            @switch($invoice->status)
                                @case('paid')
                                    <span class="badge bg-success">{{ __('paid') }}</span>
                                    @break
                                @case('partial')
                                    <span class="badge bg-info text-dark">{{ __('partial') }}</span>
                                    @break
                                @case('draft')
                                    <span class="badge bg-secondary">{{ __('draft') }}</span>
                                    @break
                                @case('sent')
                                    <span class="badge bg-primary">{{ __('sent') }}</span>
                                    @break
                                @case('cancelled')
                                    <span class="badge bg-danger">{{ __('cancelled') }}</span>
                                    @break
                            @endswitch
                        </td>
                        <td data-label="{{ __('Code') }}" class="fw-bold">{{ $invoice->code }}</td>
                        <td data-label="{{ __('Client') }}">
                            <a href="{{ route('customers.show', $invoice->customer_id) }}" class="text-decoration-none text-light">
                                {{ $invoice->customer->name }}
                            </a>
                        </td>
                        <td data-label="{{ __('Salesperson') }}">
                            @if($invoice->sales_person_id)
                                <small><a href="{{ route('accounting.sales-people.show', $invoice->sales_person_id) }}" class="text-info">{{ $invoice->salesPerson->name }}</a></small>
                            @else
                                <span class="text-muted small">-</span>
                            @endif
                        </td>
                        <td data-label="{{ __('Date') }}">{{ $invoice->date->format('Y-m-d') }}</td>
                        <td data-label="{{ __('Due Date') }}">
                            @if($invoice->due_date)
                                <span class="{{ $invoice->due_date->isPast() && $invoice->status != 'paid' ? 'text-danger fw-bold' : '' }}">
                                    {{ $invoice->due_date->format('Y-m-d') }}
                                </span>
                            @else
                                -
                            @endif
                        </td>
                        <td data-label="{{ __('Amount') }}" class="text-end fw-bold">{{ number_format($invoice->total, 2) }}</td>
                        <td data-label="{{ __('Last Updated') }}" class="small text-muted">{{ $invoice->updated_at->diffForHumans() }}</td>
                        <td data-label="{{ __('Actions') }}" class="text-end">
                            <a href="{{ route('accounting.invoices.show', $invoice) }}" class="btn btn-sm btn-outline-light">
                                <i class="fas fa-eye"></i>
                            </a>
                            @if($invoice->status != 'paid')
                            <a href="{{ route('accounting.invoices.edit', $invoice) }}" class="btn btn-sm btn-outline-warning">
                                <i class="fas fa-edit"></i>
                            </a>
                            @endif
                            @can('delete invoices')
                            <form action="{{ route('accounting.invoices.destroy', $invoice) }}" method="POST" class="d-inline"
                                  onsubmit="return confirm('{{ __('Are you sure you want to delete this invoice?') }}')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-outline-danger" title="{{ __('Delete') }}">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                            @endcan
                        </td>

                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="text-center py-5">
                            <i class="fas fa-file-invoice-dollar fa-3x text-muted mb-3"></i>
                            <h3>{{ __('No invoices found') }}</h3>
                            <p class="text-muted">{{ __('Create your first invoice to get started.') }}</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
    @if($invoices->hasPages())
    <div class="card-footer">
        {{ $invoices->links() }}
    </div>
    @endif
</div>
@endsection
