@extends('layouts.print_a4')

@section('title', 'Invoice #' . $invoice->code)
@section('doc_title', 'فاتورة مبيعات (Tax Invoice)')

@section('content')
    <div class="doc-meta">
        <div>رقم الفاتورة: <strong>{{ $invoice->code }}</strong></div>
        <div>التاريخ: <strong>{{ $invoice->date->format('Y-m-d') }}</strong></div>
        <div>تاريخ الاستحقاق: <strong>{{ $invoice->due_date ? $invoice->due_date->format('Y-m-d') : '-' }}</strong></div>
    </div>

    <div class="bill-to" style="margin-bottom: 15px;">
        <div style="display: flex; justify-content: space-between; gap: 15px;">
            <div style="width: 48%; border: 1px solid #ddd; padding: 8px; background: #f9f9f9;">
                <h5 style="margin: 0 0 5px 0; border-bottom: 1px solid #ccc; padding-bottom: 5px; font-size: 14px;">بيانات
                    العميل</h5>

                <div style="display: flex; justify-content: space-between; margin-bottom: 4px;">
                    <div style="font-weight: bold; font-size: 14px;">{{ $invoice->customer->name }}</div>
                    <div style="direction: ltr;">{{ $invoice->customer->phone }}</div>
                </div>

                @if($invoice->customer->address)
                    <div style="font-size: 12px; color: #555;">
                        {{ $invoice->customer->address }}
                    </div>
                @endif
            </div>

            <div style="width: 48%; border: 1px solid #ddd; padding: 8px;">
                <h5 style="margin: 0 0 5px 0; border-bottom: 1px solid #ccc; padding-bottom: 5px; font-size: 14px;">حالة
                    الفاتورة</h5>
                <div style="text-align: center; padding-top: 5px;">
                    @if($invoice->status == 'paid')
                        <span style="color: green; font-weight: bold; font-size: 18px;">مدفوعة (PAID)</span>
                    @elseif($invoice->status == 'partial')
                        <span style="color: orange; font-weight: bold; font-size: 18px;">مدفوعة جزئياً (PARTIAL)</span>
                    @else
                        <span style="color: red; font-weight: bold; font-size: 18px;">غير مدفوعة (UNPAID)</span>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <table class="table">
        <thead>
            <tr>
                <th>الوصف</th>
                <th>الكمية</th>
                <th>سعر الوحدة</th>
                <th>الإجمالي</th>
            </tr>
        </thead>
        <tbody>
            @foreach($invoice->items as $item)
                <tr>
                    <td style="text-align: right;">
                        {!! nl2br(e($item->description)) !!}
                        @if($item->unit)
                            <small style="color: #666;">({{ $item->unit->short_name }})</small>
                        @endif
                        @if($item->serial_key)
                            <br><small style="color: #666;">Serial: {{ $item->serial_key }}</small>
                        @endif
                        @if($item->start_date && $item->end_date)
                            <br><small style="color: #666;">
                                الفترة: {{ $item->start_date->format('Y-m-d') }} - {{ $item->end_date->format('Y-m-d') }}
                            </small>
                        @endif
                    </td>
                    <td>{{ number_format($item->quantity, 0) }}</td>
                    <td>{{ number_format($item->unit_price, 2) }}</td>
                    <td>{{ number_format($item->total, 2) }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <div class="totals-section" style="float: left; width: 300px;">
        <table class="totals-table">
            <tr>
                <td>الاجمالي الفرعي:</td>
                <td style="text-align: left;">{{ number_format($invoice->subtotal, 2) }}</td>
            </tr>
            @if($invoice->tax_amount > 0)
                <tr>
                    <td>ضريبة القيمه المضافة ({{ $invoice->tax_percent }}%):</td>
                    <td style="text-align: left;">{{ number_format($invoice->tax_amount, 2) }}</td>
                </tr>
            @endif
            @if($invoice->discount_amount > 0)
                <tr>
                    <td>الخصم {{ $invoice->discount_type == 'percent' ? '(' . ($invoice->discount_value + 0) . '%)' : '' }}:
                    </td>
                    <td style="text-align: left;">-{{ number_format($invoice->discount_amount, 2) }}</td>
                </tr>
            @endif
            @if($invoice->shipping_amount > 0)
                <tr>
                    <td>الشحن:</td>
                    <td style="text-align: left;">{{ number_format($invoice->shipping_amount, 2) }}</td>
                </tr>
            @endif
            @if($invoice->extra_expenses_amount > 0)
                <tr>
                    <td>مصاريف إضافية{{ $invoice->extra_expenses_note ? ' (' . $invoice->extra_expenses_note . ')' : '' }}:</td>
                    <td style="text-align: left;">{{ number_format($invoice->extra_expenses_amount, 2) }}</td>
                </tr>
            @endif
            <tr class="total-row">
                <td>الإجمالي الكلي:</td>
                <td style="text-align: left;">{{ number_format($invoice->total, 2) }} ج.م</td>
            </tr>
            <tr>
                <td>المدفوع:</td>
                <td style="text-align: left;">{{ number_format($invoice->paid_amount, 2) }}</td>
            </tr>
            <tr style="border-top: 1px solid #000;">
                <td><strong>المتبقي:</strong></td>
                <td style="text-align: left;"><strong>{{ number_format($invoice->total - $invoice->paid_amount, 2) }}
                        ج.م</strong></td>
            </tr>
        </table>
    </div>

    <div style="clear: both; margin-top: 20px; border-top: 1px solid #eee; padding-top: 10px;">
        <p><strong>ملاحظات:</strong> {{ $invoice->notes ?: 'شكراً لتعاملكم معنا' }}</p>
    </div>

    <div class="signature-section" style="margin-top: 30px; display: flex; justify-content: flex-end; gap: 50px;">
        <div class="signature-box" style="width: 150px; text-align: center;">
            التوقيع
            <div class="signature-line" style="border-top: 1px solid #000; margin-top: 30px;"></div>
        </div>
    </div>
@endsection